/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalcultivation.item;

import cofh.api.fluid.IFluidContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.api.item.INBTCopyIngredient;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.RayTracer;
import cofh.core.util.capabilities.FluidContainerItemWrapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalcultivation.ThermalCultivation;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWateringCan
extends ItemMulti
implements IInitializer,
IFluidContainerItem,
IMultiModeItem,
IEnchantableItem,
INBTCopyIngredient {
    private static TIntObjectHashMap<TypeEntry> typeMap = new TIntObjectHashMap();
    public static final int CAPACITY_BASE = 4000;
    public static final int CREATIVE = 32000;
    public static final int[] CAPACITY = new int[]{1, 3, 6, 10, 15};
    public static final int[] CHANCE = new int[]{40, 50, 60, 70, 80};
    public static final int[] WATER_PER_USE = new int[]{50, 150, 300, 500, 750};
    public static boolean enable = true;
    public static boolean allowFakePlayers = false;
    public static ItemStack wateringCanBasic;
    public static ItemStack wateringCanHardened;
    public static ItemStack wateringCanReinforced;
    public static ItemStack wateringCanSignalum;
    public static ItemStack wateringCanResonant;
    public static ItemStack wateringCanCreative;

    public ItemWateringCan() {
        super("thermalcultivation");
        this.func_77655_b("watering_can");
        this.func_77637_a(ThermalCultivation.tabCommon);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    protected static boolean isWater(IBlockState state) {
        return (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    public ItemStack setDefaultTag(ItemStack stack, int water) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Water", water);
        stack.func_77978_p().func_74768_a("Mode", this.getNumModes(stack) - 1);
        return stack;
    }

    public int getBaseCapacity(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemWateringCan.typeMap.get((int)metadata)).capacity;
    }

    public int getChance(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemWateringCan.typeMap.get((int)metadata)).chance;
    }

    public int getMaxRadius(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemWateringCan.typeMap.get((int)metadata)).radius;
    }

    public int getRadius(ItemStack stack) {
        return 1 + this.getMode(stack);
    }

    public int getSpace(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.setDefaultTag(stack, 0);
        }
        return this.getCapacity(stack) - this.getWaterStored(stack);
    }

    public int getWaterStored(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.setDefaultTag(stack, 0);
        }
        return stack.func_77978_p().func_74762_e("Water");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        int metadata = ItemHelper.getItemDamage((ItemStack)stack);
        int radius = this.getRadius(stack) * 2 + 1;
        tooltip.add(StringHelper.getInfoText((String)"info.thermalcultivation.watering_can.0"));
        tooltip.add(StringHelper.localize((String)"info.cofh.area") + ": " + radius + "x" + radius);
        if (this.getNumModes(stack) > 1) {
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalcultivation.watering_can.1", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        }
        if (metadata == 32000) {
            tooltip.add(StringHelper.localize((String)FluidRegistry.WATER.getUnlocalizedName()) + ": " + StringHelper.localize((String)"info.cofh.infinite"));
        } else {
            tooltip.add(StringHelper.localize((String)(StringHelper.localize((String)FluidRegistry.WATER.getUnlocalizedName()) + ": " + StringHelper.formatNumber((long)this.getWaterStored(stack)) + " / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB")));
            tooltip.add(StringHelper.getNoticeText((String)"info.thermalcultivation.watering_can.2"));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), 0));
                    items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), this.getBaseCapacity(metadata)));
                    continue;
                }
                items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), this.getBaseCapacity(metadata)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (!this.isActive(stack)) {
            return;
        }
        long activeTime = stack.func_77978_p().func_74763_f("Active");
        if (entity.field_70170_p.func_82737_E() > activeTime) {
            stack.func_77978_p().func_82580_o("Active");
        }
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || ItemHelper.getItemDamage((ItemStack)oldStack) != ItemHelper.getItemDamage((ItemStack)newStack) || this.getWaterStored(oldStack) > 0 != this.getWaterStored(newStack) > 0 || this.getWaterStored(newStack) > 0 && this.isActive(oldStack) != this.isActive(newStack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemHelper.getItemDamage((ItemStack)stack) != 32000;
    }

    public int func_77619_b() {
        return 10;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 4219135;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.setDefaultTag(stack, 0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Water") / (double)this.getCapacity(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)true);
        BlockPos tracePos = traceResult.func_178782_a();
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af() || !world.func_175660_a(player, tracePos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (ItemWateringCan.isWater(world.func_180495_p(tracePos)) && this.getSpace(stack) > 0) {
            world.func_180501_a(tracePos, Blocks.field_150350_a.func_176223_P(), 11);
            this.fill(stack, new FluidStack(FluidRegistry.WATER, 1000), true);
            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos offsetPos;
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)true);
        BlockPos tracePos = traceResult.func_178782_a();
        IBlockState traceState = world.func_180495_p(tracePos);
        if (player instanceof FakePlayer && !allowFakePlayers) {
            return EnumActionResult.FAIL;
        }
        if (player.func_70093_af() && ItemWateringCan.isWater(traceState)) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        BlockPos blockPos = offsetPos = traceState.isSideSolid((IBlockAccess)world, tracePos, traceResult.field_178784_b) || traceState.func_185904_a().func_76224_d() ? tracePos.func_177972_a(traceResult.field_178784_b) : tracePos;
        if (this.getWaterStored(stack) < WATER_PER_USE[0]) {
            return EnumActionResult.FAIL;
        }
        this.setActive(stack, player);
        int radius = this.getRadius(stack);
        int x = offsetPos.func_177958_n();
        double y = (double)offsetPos.func_177956_o() + 0.4;
        int z = offsetPos.func_177952_p();
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int k = z - radius; k <= z + radius; ++k) {
                world.func_175688_a(EnumParticleTypes.WATER_DROP, (double)((float)i + world.field_73012_v.nextFloat()), y, (double)((float)k + world.field_73012_v.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        Iterable area = BlockPos.func_177975_b((BlockPos)offsetPos.func_177982_a(-radius, -1, -radius), (BlockPos)offsetPos.func_177982_a(radius, 1, radius));
        for (BlockPos scan : area) {
            int moisture;
            IBlockState state = world.func_180495_p(scan);
            if (!(state.func_177230_c() instanceof BlockFarmland) || (moisture = ((Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a)).intValue()) >= 7) continue;
            world.func_180501_a(scan, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
        if (ServerHelper.isServerWorld((World)world)) {
            if (world.field_73012_v.nextInt(100) < this.getChance(ItemHelper.getItemDamage((ItemStack)stack)) - 5 * this.getMode(stack)) {
                for (BlockPos scan : area) {
                    Block plant = world.func_180495_p(scan).func_177230_c();
                    if (!(plant instanceof IGrowable) && !(plant instanceof IPlantable) && plant != Blocks.field_150391_bh && plant != Blocks.field_185766_cS) continue;
                    world.func_180497_b(scan, plant, 0, 1);
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.drain(stack, WATER_PER_USE[this.getMode(stack)], true);
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Active");
    }

    public void setActive(ItemStack stack, EntityPlayer player) {
        stack.func_77978_p().func_74772_a("Active", player.field_70170_p.func_82737_E() + 10L);
    }

    public int getMode(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Mode");
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Mode", mode);
        return false;
    }

    public boolean incrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (++curMode >= this.getNumModes(stack)) {
            curMode = 0;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public boolean decrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (--curMode <= 0) {
            curMode = this.getNumModes(stack) - 1;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public int getNumModes(ItemStack stack) {
        return this.getMaxRadius(ItemHelper.getItemDamage((ItemStack)stack));
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.6f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getRadius(stack) * 2 + 1;
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.area") + ": " + radius + "x" + radius));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            Object[] objectArray = new Object[2];
            objectArray[0] = ((TypeEntry)ItemWateringCan.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name;
            objectArray[1] = this.getWaterStored(stack) > 0 ? (this.isActive(stack) ? "tipped" : "level") : "empty";
            return new ModelResourceLocation(this.getRegistryName(), String.format("type=%s,water=%s", objectArray));
        });
        String[] waterStates = new String[]{"level", "tipped", "empty"};
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int i = 0; i < 3; ++i) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("type=%s,water=%s", ((ItemMulti.ItemEntry)entry.getValue()).name, waterStates[i]))});
            }
        }
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container, 0);
        }
        int stored = container.func_77978_p().func_74762_e("Water");
        return new FluidStack(FluidRegistry.WATER, stored);
    }

    public int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemWateringCan.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container, 0);
        }
        if (resource == null || !FluidRegistry.WATER.equals(resource.getFluid())) {
            return 0;
        }
        int stored = container.func_77978_p().func_74762_e("Water");
        int fill = Math.min(resource.amount, this.getCapacity(container) - stored);
        if (doFill && ItemHelper.getItemDamage((ItemStack)container) != 32000) {
            container.func_77978_p().func_74768_a("Water", stored += fill);
        }
        return fill;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container, 0);
        }
        if (maxDrain == 0) {
            return null;
        }
        int stored = container.func_77978_p().func_74762_e("Water");
        int drain = Math.min(maxDrain, stored);
        if (doDrain && ItemHelper.getItemDamage((ItemStack)container) != 32000) {
            container.func_77978_p().func_74768_a("Water", stored -= drain);
        }
        return new FluidStack(FluidRegistry.WATER, drain);
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapper(stack, (IFluidContainerItem)this);
    }

    public boolean initialize() {
        ItemWateringCan.config();
        wateringCanBasic = this.addEntryItem(0, "standard0", CAPACITY[0], CHANCE[0], 1, EnumRarity.COMMON);
        wateringCanHardened = this.addEntryItem(1, "standard1", CAPACITY[1], CHANCE[1], 2, EnumRarity.COMMON);
        wateringCanReinforced = this.addEntryItem(2, "standard2", CAPACITY[2], CHANCE[2], 3, EnumRarity.UNCOMMON);
        wateringCanSignalum = this.addEntryItem(3, "standard3", CAPACITY[3], CHANCE[3], 4, EnumRarity.UNCOMMON);
        wateringCanResonant = this.addEntryItem(4, "standard4", CAPACITY[4], CHANCE[4], 5, EnumRarity.RARE);
        wateringCanCreative = this.addEntryItem(32000, "creative", CAPACITY[4], 200, 5, EnumRarity.EPIC, false);
        ThermalCultivation.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean register() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)wateringCanBasic, (Object[])new Object[]{"I  ", "IXI", " I ", Character.valueOf('I'), "ingotCopper", Character.valueOf('X'), Items.field_151133_ar});
        return true;
    }

    private static void config() {
        String category = "Item.WateringCan";
        enable = ThermalCultivation.CONFIG.get(category, "Enable", true);
        String comment = "If TRUE, Fake Players (such as Autonomous Activators) will be able to use the Watering Can.";
        allowFakePlayers = ThermalCultivation.CONFIG.getConfiguration().getBoolean("AllowFakePlayers", category, allowFakePlayers, comment);
        int capacity = 4000;
        comment = "Adjust this value to change the amount of Water (in mB) stored by a Basic Watering Can. This base value will scale with item level.";
        capacity = ThermalCultivation.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    private void addEntry(int metadata, String name, int capacity, int chance, int radius, boolean enchantable) {
        typeMap.put(metadata, (Object)new TypeEntry(name, capacity, chance, radius, enchantable));
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, int chance, int radius, EnumRarity rarity, boolean enchantable) {
        this.addEntry(metadata, name, capacity, chance, radius, enchantable);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, int chance, int radius, EnumRarity rarity) {
        this.addEntry(metadata, name, capacity, chance, radius, true);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int capacity;
        public final int chance;
        public final int radius;
        public final boolean enchantable;

        TypeEntry(String name, int capacity, int chance, int radius, boolean enchantable) {
            this.name = name;
            this.capacity = capacity;
            this.chance = chance;
            this.radius = radius;
            this.enchantable = enchantable;
        }
    }
}

