/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalcultivation.block;

import cofh.api.util.ThermalExpansionHelper;
import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalcultivation.ThermalCultivation;
import cofh.thermalcultivation.block.ItemBlockSoil;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockSoil
extends BlockCore
implements IInitializer,
IModelRegister {
    protected static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static final PropertyBool TILLED = PropertyBool.func_177716_a((String)"tilled");
    public static ItemStack soilBasic;
    public static ItemStack soilRich;
    public static ItemStack soilFlux;
    public static ItemStack soilMana;

    public BlockSoil() {
        super(Material.field_151578_c, "thermalcultivation");
        this.func_149663_c("soil");
        this.func_149647_a(ThermalCultivation.tabCommon);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149675_a(true);
        this.func_149713_g(255);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, TILLED});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta & 7))).func_177226_a((IProperty)TILLED, (Comparable)Boolean.valueOf(meta > 7));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata() + ((Boolean)state.func_177229_b((IProperty)TILLED) != false ? 8 : 0);
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            this.turnToDirt(world, pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.hasCrop(world, pos)) {
            return;
        }
        switch ((Type)((Object)state.func_177229_b(VARIANT))) {
            case BASIC: {
                break;
            }
            case RICH: {
                if (world.field_73012_v.nextInt(100) < 25) break;
            }
            case FLUX: {
                if (world.field_73012_v.nextInt(100) < 25) break;
                BlockPos up = pos.func_177984_a();
                world.func_180497_b(up, world.func_180495_p(up).func_177230_c(), 0, 1);
            }
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plantType) {
            case Plains: 
            case Desert: 
            case Beach: {
                return true;
            }
            case Crop: {
                return (Boolean)state.func_177229_b((IProperty)TILLED);
            }
        }
        return false;
    }

    public boolean isFertile(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)TILLED);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TILLED) == false;
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TILLED) == false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)TILLED) != false ? FARMLAND_AABB : field_185505_j;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
    }

    protected boolean hasCrop(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)block);
    }

    protected void turnToDirt(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos).func_177226_a((IProperty)TILLED, (Comparable)Boolean.valueOf(false));
        world.func_175656_a(pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "tilled=false,type=" + Type.byMetadata(i).func_176610_l()));
        }
    }

    @SubscribeEvent
    public void handleUseHoeEvent(UseHoeEvent event) {
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(event.getPos());
        if (state.func_177230_c() == this) {
            if (!((Boolean)state.func_177229_b((IProperty)TILLED)).booleanValue()) {
                world.func_175656_a(event.getPos(), state.func_177226_a((IProperty)TILLED, (Comparable)Boolean.valueOf(true)));
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setCanceled(true);
            }
        }
    }

    public boolean initialize() {
        this.setRegistryName("soil");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockSoil itemBlock = new ItemBlockSoil((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        soilBasic = new ItemStack((Block)this, 1, Type.BASIC.getMetadata());
        soilRich = new ItemStack((Block)this, 1, Type.RICH.getMetadata());
        soilFlux = new ItemStack((Block)this, 1, Type.FLUX.getMetadata());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ThermalCultivation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        if (!Loader.isModLoaded((String)"thermalexpansion")) {
            RecipeHelper.addShapelessRecipe((ItemStack)soilRich, (Object[])new Object[]{soilBasic, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b())});
            RecipeHelper.addShapelessOreRecipe((ItemStack)soilFlux, (Object[])new Object[]{soilRich, "dustRedstone"});
        } else {
            ThermalExpansionHelper.addTransposerFill((int)2000, (ItemStack)soilBasic, (ItemStack)soilRich, (FluidStack)new FluidStack(TFFluids.fluidSap, 500), (boolean)false);
            ThermalExpansionHelper.addChargerRecipe((int)8000, (ItemStack)soilRich, (ItemStack)soilFlux);
        }
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        BASIC(0, "basic"),
        RICH(1, "rich"),
        FLUX(2, "flux", 7, EnumRarity.UNCOMMON);

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final int light;
        private final EnumRarity rarity;

        private Type(int metadata, String name, int light, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.rarity = rarity;
        }

        private Type(int metadata, String name, int light) {
            this(metadata, name, light, EnumRarity.COMMON);
        }

        private Type(int metadata, String name) {
            this(metadata, name, 0, EnumRarity.COMMON);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

