/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.rftoolsdim.config.DimletConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.SkyRegistry;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import mcjty.rftoolsdim.varia.RarityRandomSelector;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;

public class DimletRandomizer {
    public static final int RARITY_0 = 0;
    public static final int RARITY_1 = 1;
    public static final int RARITY_2 = 2;
    public static final int RARITY_3 = 3;
    public static final int RARITY_4 = 4;
    public static final int RARITY_5 = 5;
    public static final int RARITY_6 = 6;
    private static RarityRandomSelector<Integer, DimletKey> randomDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomUncraftableDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomMaterialDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomLiquidDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomMobDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomStructureDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomEffectDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomFeatureDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomTerrainDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomSkyDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomSkyBodyDimlets;
    private static RarityRandomSelector<Integer, DimletKey> randomWeatherDimlets;
    private static RarityRandomSelector<Integer, ItemStack> dimletPartDistribution;

    public static void init() {
        randomDimlets = null;
        randomUncraftableDimlets = null;
        randomMaterialDimlets = null;
        randomLiquidDimlets = null;
        randomMobDimlets = null;
        randomStructureDimlets = null;
        randomEffectDimlets = null;
        randomFeatureDimlets = null;
        randomTerrainDimlets = null;
        randomSkyDimlets = null;
        randomSkyBodyDimlets = null;
        randomWeatherDimlets = null;
    }

    private static void setupWeightedRandomList() {
        if (randomDimlets != null) {
            return;
        }
        Map<DimletKey, Settings> knownDimlets = KnownDimletConfiguration.getKnownDimlets();
        float rarity0 = DimletConfiguration.rarity0;
        float rarity1 = DimletConfiguration.rarity1;
        float rarity2 = DimletConfiguration.rarity2;
        float rarity3 = DimletConfiguration.rarity3;
        float rarity4 = DimletConfiguration.rarity4;
        float rarity5 = DimletConfiguration.rarity5;
        float rarity6 = DimletConfiguration.rarity6;
        randomDimlets = new RarityRandomSelector();
        DimletRandomizer.setupRarity(randomDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomUncraftableDimlets = new RarityRandomSelector();
        DimletRandomizer.setupRarity(randomUncraftableDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        for (Map.Entry<DimletKey, Settings> entry : knownDimlets.entrySet()) {
            DimletKey key = entry.getKey();
            Settings settings = KnownDimletConfiguration.getSettings(key);
            if (settings == null || !settings.isWorldgen()) continue;
            randomDimlets.addItem(entry.getValue().getRarity(), key);
            if (key.getType() == DimletType.DIMLET_MATERIAL) {
                if (randomMaterialDimlets == null) {
                    randomMaterialDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomMaterialDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomMaterialDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_LIQUID) {
                if (randomLiquidDimlets == null) {
                    randomLiquidDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomLiquidDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomLiquidDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_MOB) {
                if (randomMobDimlets == null) {
                    randomMobDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomMobDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomMobDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_EFFECT) {
                if (randomEffectDimlets == null) {
                    randomEffectDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomEffectDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomEffectDimlets.addItem(entry.getValue().getRarity(), key);
                randomUncraftableDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_FEATURE) {
                if (randomFeatureDimlets == null) {
                    randomFeatureDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomFeatureDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomFeatureDimlets.addItem(entry.getValue().getRarity(), key);
                randomUncraftableDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_STRUCTURE) {
                if (randomStructureDimlets == null) {
                    randomStructureDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomStructureDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomStructureDimlets.addItem(entry.getValue().getRarity(), key);
                randomUncraftableDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_TERRAIN) {
                if (randomTerrainDimlets == null) {
                    randomTerrainDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomTerrainDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomTerrainDimlets.addItem(entry.getValue().getRarity(), key);
                randomUncraftableDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_WEATHER) {
                if (randomWeatherDimlets == null) {
                    randomWeatherDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomWeatherDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomWeatherDimlets.addItem(entry.getValue().getRarity(), key);
                randomUncraftableDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_CONTROLLER) {
                randomUncraftableDimlets.addItem(entry.getValue().getRarity(), key);
                continue;
            }
            if (key.getType() != DimletType.DIMLET_SKY) continue;
            if (randomSkyDimlets == null) {
                randomSkyDimlets = new RarityRandomSelector();
                DimletRandomizer.setupRarity(randomSkyDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
            }
            randomSkyDimlets.addItem(entry.getValue().getRarity(), key);
            if (SkyRegistry.isSkyBody(key)) {
                if (randomSkyBodyDimlets == null) {
                    randomSkyBodyDimlets = new RarityRandomSelector();
                    DimletRandomizer.setupRarity(randomSkyBodyDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
                }
                randomSkyBodyDimlets.addItem(entry.getValue().getRarity(), key);
            }
            randomUncraftableDimlets.addItem(entry.getValue().getRarity(), key);
        }
    }

    private static void setupRarity(RarityRandomSelector<Integer, DimletKey> randomDimlets, float rarity0, float rarity1, float rarity2, float rarity3, float rarity4, float rarity5, float rarity6) {
        randomDimlets.addRarity(0, rarity0);
        randomDimlets.addRarity(1, rarity1);
        randomDimlets.addRarity(2, rarity2);
        randomDimlets.addRarity(3, rarity3);
        randomDimlets.addRarity(4, rarity4);
        randomDimlets.addRarity(5, rarity5);
        randomDimlets.addRarity(6, rarity6);
    }

    public static DimletKey getRandomTerrain(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomTerrainDimlets == null ? null : randomTerrainDimlets.select(random);
    }

    public static DimletKey getRandomFeature(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomFeatureDimlets == null ? null : randomFeatureDimlets.select(random);
    }

    public static DimletKey getRandomEffect(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomEffectDimlets == null ? null : randomEffectDimlets.select(random);
    }

    public static DimletKey getRandomStructure(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomStructureDimlets == null ? null : randomStructureDimlets.select(random);
    }

    public static DimletKey getRandomFluidBlock(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomLiquidDimlets == null ? null : randomLiquidDimlets.select(random);
    }

    public static DimletKey getRandomMaterialBlock(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomMaterialDimlets == null ? null : randomMaterialDimlets.select(random);
    }

    public static DimletKey getRandomSky(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomSkyDimlets == null ? null : randomSkyDimlets.select(random);
    }

    public static DimletKey getRandomWeather(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomWeatherDimlets == null ? null : randomWeatherDimlets.select(random);
    }

    public static DimletKey getRandomSkyBody(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomSkyBodyDimlets == null ? null : randomSkyBodyDimlets.select(random);
    }

    public static DimletKey getRandomController(Random random) {
        ControllerType type = ControllerType.values()[random.nextInt(ControllerType.values().length)];
        return new DimletKey(DimletType.DIMLET_CONTROLLER, type.getId());
    }

    public static DimletKey getRandomBiome(Random random) {
        Biome biome;
        ArrayList keys = new ArrayList(Biome.field_185377_q.func_148742_b());
        int size = keys.size();
        while ((biome = (Biome)Biome.field_185377_q.func_82594_a(keys.get(random.nextInt(size)))) == null) {
        }
        return new DimletKey(DimletType.DIMLET_BIOME, biome.field_76791_y);
    }

    public static DimletKey getRandomMob(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return randomMobDimlets == null ? null : randomMobDimlets.select(random);
    }

    public static RarityRandomSelector<Integer, DimletKey> getRandomDimlets() {
        DimletRandomizer.setupWeightedRandomList();
        return randomDimlets;
    }

    public static RarityRandomSelector<Integer, DimletKey> getRandomUncraftableDimlets() {
        DimletRandomizer.setupWeightedRandomList();
        return randomUncraftableDimlets;
    }

    public static ItemStack getRandomPart(Random random) {
        if (dimletPartDistribution == null) {
            dimletPartDistribution = new RarityRandomSelector();
            dimletPartDistribution.addRarity(0, DimletConfiguration.rarity0);
            dimletPartDistribution.addRarity(1, DimletConfiguration.rarity1);
            dimletPartDistribution.addRarity(2, DimletConfiguration.rarity2);
            dimletPartDistribution.addRarity(3, DimletConfiguration.rarity3);
            dimletPartDistribution.addRarity(4, DimletConfiguration.rarity4);
            dimletPartDistribution.addRarity(5, DimletConfiguration.rarity5);
            dimletPartDistribution.addRarity(6, DimletConfiguration.rarity6);
            List<List<ItemStack>> stacks = KnownDimletConfiguration.getRandomPartLists();
            for (int i = 0; i < stacks.size(); ++i) {
                int finalI = i;
                stacks.get(i).stream().forEach(s -> dimletPartDistribution.addItem(finalI, (ItemStack)s));
            }
        }
        return dimletPartDistribution.select(random).func_77946_l();
    }
}

