/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.commands;

import mcjty.rftoolsdim.commands.AbstractRfToolsCommand;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CmdSetOwner
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<id> <owner>";
    }

    @Override
    public String getCommand() {
        return "setowner";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 3) {
            TextComponentString component = new TextComponentString(TextFormatting.RED + "The dimension and player parameters are missing!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            return;
        }
        if (args.length > 3) {
            TextComponentString component = new TextComponentString(TextFormatting.RED + "Too many parameters!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            return;
        }
        int dim = this.fetchInt(sender, args, 1, 0);
        String playerName = this.fetchString(sender, args, 2, null);
        World world = sender.func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        if (dimensionManager.getDimensionDescriptor(dim) == null) {
            TextComponentString component = new TextComponentString(TextFormatting.RED + "Not an RFTools dimension!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            return;
        }
        for (EntityPlayerMP entityPlayerMP : ((WorldServer)world).func_73046_m().func_184103_al().func_181057_v()) {
            if (!playerName.equals(entityPlayerMP.func_145748_c_())) continue;
            DimensionInformation information = dimensionManager.getDimensionInformation(dim);
            information.setOwner(playerName, entityPlayerMP.func_146103_bH().getId());
            TextComponentString component = new TextComponentString(TextFormatting.GREEN + "Owner of dimension changed!");
            if (sender instanceof EntityPlayer) {
                ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
            } else {
                sender.func_145747_a((ITextComponent)component);
            }
            dimensionManager.save(world);
            return;
        }
        TextComponentString component = new TextComponentString(TextFormatting.RED + "Could not find player!");
        if (sender instanceof EntityPlayer) {
            ((EntityPlayer)sender).func_146105_b((ITextComponent)component, false);
        } else {
            sender.func_145747_a((ITextComponent)component);
        }
    }
}

