/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.editor;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Broadcaster;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.blocks.editor.DimensionEditorBlock;
import mcjty.rftoolsdim.blocks.editor.DimensionEditorContainer;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.MachineConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.dimlets.DimletCosts;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.IDimletType;
import mcjty.rftoolsdim.dimensions.world.WorldGenerationTools;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class DimensionEditorTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_GETEDITING = "getEditing";
    public static final String CLIENTCMD_GETEDITING = "getEditing";
    private static int editPercentage = 0;
    private int ticksLeft = -1;
    private int ticksCost = -1;
    private int rfPerTick = -1;
    private int state = 0;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimensionEditorContainer.factory, 2);

    public DimensionEditorTileEntity() {
        super(MachineConfiguration.EDITOR_MAXENERGY, MachineConfiguration.EDITOR_RECEIVEPERTICK);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        int oldstate = this.state;
        super.onDataPacket(net, packet);
        if (oldstate != this.state) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ItemStack injectableItemStack = this.validateInjectableItemStack();
        if (injectableItemStack.func_190926_b()) {
            return;
        }
        ItemStack dimensionItemStack = this.validateDimensionItemStack();
        if (dimensionItemStack.func_190926_b()) {
            return;
        }
        if (this.ticksLeft == -1) {
            if (this.isMatterReceiver(injectableItemStack)) {
                this.ticksLeft = this.ticksCost = DimletCosts.baseDimensionTickCost + 1000;
                this.rfPerTick = DimletCosts.baseDimensionCreationCost + 200;
            } else if (this.isTNT(injectableItemStack)) {
                this.ticksLeft = this.ticksCost = 600;
                this.rfPerTick = 10;
            } else {
                DimletKey key = KnownDimletConfiguration.getDimletKey(injectableItemStack);
                Settings settings = KnownDimletConfiguration.getSettings(key);
                this.ticksLeft = this.ticksCost = DimletCosts.baseDimensionTickCost + settings.getTickCost();
                this.rfPerTick = DimletCosts.baseDimensionCreationCost + settings.getCreateCost();
            }
        } else {
            int rf = this.getEnergyStored(EnumFacing.DOWN);
            int rfpt = this.rfPerTick;
            if (rf >= (rfpt = (int)((float)rfpt * (2.0f - this.getInfusedFactor()) / 2.0f))) {
                this.consumeEnergy(rfpt);
                --this.ticksLeft;
                if (this.ticksLeft <= 0) {
                    RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(this.func_145831_w());
                    ItemStack dimensionTab = this.validateDimensionItemStack();
                    NBTTagCompound tagCompound = dimensionTab.func_77978_p();
                    int id = tagCompound.func_74762_e("id");
                    injectableItemStack = this.validateInjectableItemStack();
                    if (this.isMatterReceiver(injectableItemStack)) {
                        Item item;
                        World dimWorld = RfToolsDimensionManager.getWorldForDimension(this.func_145831_w(), id);
                        int y = this.findGoodReceiverLocation(dimWorld);
                        if (y == -1) {
                            y = dimWorld.func_72800_K() / 2;
                        }
                        if ((item = injectableItemStack.func_77973_b()) instanceof ItemBlock) {
                            ItemBlock itemBlock = (ItemBlock)item;
                            IBlockState state = itemBlock.func_179223_d().func_176203_a(itemBlock.getMetadata(injectableItemStack));
                            BlockPos pos = new BlockPos(8, y, 8);
                            dimWorld.func_180501_a(pos, state, 2);
                            Block block = dimWorld.func_180495_p(pos).func_177230_c();
                            block.func_180639_a(dimWorld, pos, state, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)dimWorld)), EnumHand.MAIN_HAND, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
                            block.func_180633_a(dimWorld, pos, state, null, injectableItemStack);
                            dimWorld.func_175698_g(pos.func_177984_a());
                            dimWorld.func_175698_g(pos.func_177981_b(2));
                        }
                    } else if (this.isTNT(injectableItemStack)) {
                        this.safeDeleteDimension(id, dimensionTab);
                    } else {
                        DimletKey key = KnownDimletConfiguration.getDimletKey(injectableItemStack);
                        DimensionInformation information = dimensionManager.getDimensionInformation(id);
                        information.injectDimlet(key);
                        dimensionManager.save(this.func_145831_w());
                    }
                    this.inventoryHelper.decrStackSize(0, 1);
                    this.stopInjecting();
                }
            }
        }
        this.func_70296_d();
        this.setState();
    }

    private void safeDeleteDimension(int id, ItemStack dimensionTab) {
        WorldServer w = DimensionManager.getWorld((int)id);
        if (w != null) {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"Dimension cannot be deleted. It is still in use!", (float)10.0f);
            return;
        }
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(this.func_145831_w());
        DimensionInformation information = dimensionManager.getDimensionInformation(id);
        if (information.getOwner() == null) {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"You cannot delete a dimension without an owner!", (float)10.0f);
            return;
        }
        if (this.getOwnerUUID() == null) {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"This machine has no proper owner and cannot delete dimensions!", (float)10.0f);
            return;
        }
        if (!this.getOwnerUUID().equals(information.getOwner())) {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"This machine's owner differs from the dimensions owner!", (float)10.0f);
            return;
        }
        RFToolsDim.teleportationManager.removeReceiverDestinations(this.func_145831_w(), id);
        dimensionManager.removeDimension(id);
        dimensionManager.reclaimId(id);
        dimensionManager.save(this.func_145831_w());
        DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(this.func_145831_w());
        dimensionStorage.removeDimension(id);
        dimensionStorage.save(this.func_145831_w());
        if (GeneralConfiguration.dimensionFolderIsDeletedWithSafeDel) {
            File rootDirectory = DimensionManager.getCurrentSaveRootDirectory();
            try {
                FileUtils.deleteDirectory((File)new File(rootDirectory.getPath() + File.separator + "RFTOOLS" + id));
                Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"Dimension deleted and dimension folder succesfully wiped!", (float)10.0f);
            }
            catch (IOException e) {
                Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"Dimension deleted but dimension folder could not be completely wiped!", (float)10.0f);
            }
        } else {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"Dimension deleted. Please remove the dimension folder from disk!", (float)10.0f);
        }
        dimensionTab.func_77978_p().func_82580_o("id");
        int tickCost = dimensionTab.func_77978_p().func_74762_e("tickCost");
        dimensionTab.func_77978_p().func_74768_a("ticksLeft", tickCost);
    }

    private int findGoodReceiverLocation(World dimWorld) {
        int y = WorldGenerationTools.findSuitableEmptySpot(dimWorld, 8, 8);
        return ++y;
    }

    private ItemStack validateInjectableItemStack() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            this.stopInjecting();
            return ItemStack.field_190927_a;
        }
        if (this.isMatterReceiver(itemStack)) {
            return itemStack;
        }
        if (this.isTNT(itemStack)) {
            return this.canDeleteDimension(itemStack);
        }
        DimletKey key = KnownDimletConfiguration.getDimletKey(itemStack);
        DimletType type = key.getType();
        IDimletType itype = type.dimletType;
        if (itype.isInjectable()) {
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack canDeleteDimension(ItemStack itemStack) {
        if (!GeneralConfiguration.playersCanDeleteDimensions) {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"Players cannot delete dimensions!", (float)10.0f);
            return ItemStack.field_190927_a;
        }
        if (!GeneralConfiguration.editorCanDeleteDimensions) {
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"Dimension deletion with the editor is not enabled!", (float)10.0f);
            return ItemStack.field_190927_a;
        }
        ItemStack dimensionStack = this.inventoryHelper.getStackInSlot(1);
        if (dimensionStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tagCompound = dimensionStack.func_77978_p();
        int id = tagCompound.func_74762_e("id");
        if (id == 0) {
            return ItemStack.field_190927_a;
        }
        DimensionInformation information = RfToolsDimensionManager.getDimensionManager(this.func_145831_w()).getDimensionInformation(id);
        if (this.getOwnerUUID() != null && this.getOwnerUUID().equals(information.getOwner())) {
            return itemStack;
        }
        Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)"This machine's owner differs from the dimensions owner!", (float)10.0f);
        return ItemStack.field_190927_a;
    }

    private boolean isMatterReceiver(ItemStack itemStack) {
        Block receiver;
        Block block = BlockTools.getBlock((ItemStack)itemStack);
        return block == (receiver = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rftools", "matter_receiver")));
    }

    private boolean isTNT(ItemStack itemStack) {
        Block block = BlockTools.getBlock((ItemStack)itemStack);
        return block == Blocks.field_150335_W;
    }

    private ItemStack validateDimensionItemStack() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(1);
        if (itemStack.func_190926_b()) {
            this.stopInjecting();
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        int id = tagCompound.func_74762_e("id");
        if (id == 0) {
            this.stopInjecting();
            return ItemStack.field_190927_a;
        }
        return itemStack;
    }

    private void stopInjecting() {
        this.setState();
        this.ticksLeft = -1;
        this.ticksCost = -1;
        this.rfPerTick = -1;
        this.func_70296_d();
    }

    public DimensionEditorBlock.OperationType getState() {
        return DimensionEditorBlock.OperationType.values()[this.state];
    }

    private void setState() {
        int oldstate = this.state;
        this.state = 0;
        this.state = this.ticksLeft == 0 ? 0 : (this.ticksLeft == -1 ? 1 : ((this.ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        if (oldstate != this.state) {
            this.markDirtyClient();
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return DimensionEditorContainer.factory.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return DimensionEditorContainer.factory.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return DimensionEditorContainer.factory.isOutputSlot(index);
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void requestBuildingPercentage() {
        RFToolsDimMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer("rftoolsdim", this.func_174877_v(), "getEditing", "getEditing", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getEditing".equals(command)) {
            if (this.ticksLeft == -1) {
                return 0;
            }
            return (this.ticksCost - this.ticksLeft) * 100 / this.ticksCost;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getEditing".equals(command)) {
            editPercentage = result;
            return true;
        }
        return false;
    }

    public static int getEditPercentage() {
        return editPercentage;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.state = tagCompound.func_74771_c("state");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.ticksLeft = tagCompound.func_74762_e("ticksLeft");
        this.ticksCost = tagCompound.func_74762_e("ticksCost");
        this.rfPerTick = tagCompound.func_74762_e("rfPerTick");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74774_a("state", (byte)this.state);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("ticksLeft", this.ticksLeft);
        tagCompound.func_74768_a("ticksCost", this.ticksCost);
        tagCompound.func_74768_a("rfPerTick", this.rfPerTick);
    }
}

