/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.Random;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class BiomeAbsorberTileEntity
extends GenericTileEntity
implements ITickable {
    private int absorbing = 0;
    private String biomeId = null;

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    protected void checkStateClient() {
        if (this.absorbing > 0) {
            Random rand = this.func_145831_w().field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.func_145831_w().func_175688_a(EnumParticleTypes.PORTAL, (double)((float)this.func_174877_v().func_177958_n() + 0.5f) + x * r, (double)((float)this.func_174877_v().func_177956_o() + 0.5f) + y * r, (double)((float)this.func_174877_v().func_177952_p() + 0.5f) + z * r, -x, -y, -z, new int[0]);
        }
    }

    protected void checkStateServer() {
        if (this.absorbing > 0) {
            Biome Biome2 = this.func_145831_w().getBiomeForCoordsBody(this.func_174877_v());
            if (Biome2 == null || !Biome2.getRegistryName().toString().equals(this.biomeId)) {
                return;
            }
            --this.absorbing;
            this.markDirtyClient();
        }
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public String getBiomeName() {
        return BiomeAbsorberTileEntity.getBiomeName(this.biomeId);
    }

    public static String getBiomeName(String biomeId) {
        if (biomeId == null) {
            return null;
        }
        Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeId));
        return biome == null ? null : biome.field_76791_y;
    }

    public void placeDown() {
        if (this.biomeId == null) {
            Biome Biome2 = this.func_145831_w().getBiomeForCoordsBody(this.func_174877_v());
            if (Biome2 == null) {
                this.biomeId = null;
                this.absorbing = 0;
            } else if (!Biome2.getRegistryName().toString().equals(this.biomeId)) {
                this.biomeId = Biome2.getRegistryName().toString();
                this.absorbing = DimletConstructionConfiguration.maxBiomeAbsorbtion;
            }
            this.func_70296_d();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("absorbing", this.absorbing);
        if (this.biomeId != null) {
            tagCompound.func_74778_a("biome", this.biomeId);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.absorbing = tagCompound.func_74762_e("absorbing");
        this.biomeId = tagCompound.func_74764_b("biome") ? tagCompound.func_74779_i("biome") : null;
    }
}

