/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim;

import com.google.common.base.Function;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import java.util.Optional;
import javax.annotation.Nullable;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.MainCompatHandler;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.teleportation.ITeleportationManager;
import mcjty.rftoolsdim.api.dimension.IDimensionManager;
import mcjty.rftoolsdim.api.dimlet.IDimletConfigurationManager;
import mcjty.rftoolsdim.apiimpl.DimensionManager;
import mcjty.rftoolsdim.apiimpl.DimletConfigurationManager;
import mcjty.rftoolsdim.commands.CommandRftDb;
import mcjty.rftoolsdim.commands.CommandRftDim;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.network.DimensionSyncChannelHandler;
import mcjty.rftoolsdim.proxy.CommonProxy;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="rftoolsdim", name="RFTools Dimensions", dependencies="required-after:mcjtylib_ng@[2.4.3,);required-after:rftools@[6.10,);after:forge@[13.19.0.2176,)", version="5.04", acceptedMinecraftVersions="[1.12]")
public class RFToolsDim
implements ModBase {
    public static final String MODID = "rftoolsdim";
    public static final String VERSION = "5.04";
    public static final String MIN_RFTOOLS_VER = "6.10";
    public static final String MIN_FORGE11_VER = "13.19.0.2176";
    public static final String MIN_MCJTYLIB_VER = "2.4.3";
    @SidedProxy(clientSide="mcjty.rftoolsdim.proxy.ClientProxy", serverSide="mcjty.rftoolsdim.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="rftoolsdim")
    public static RFToolsDim instance;
    public static boolean chisel;
    public static ITeleportationManager teleportationManager;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    private static int modGuiIndex;
    public static final int GUI_DIMENSION_ENSCRIBER;
    public static final int GUI_DIMENSION_BUILDER;
    public static final int GUI_DIMENSION_EDITOR;
    public static final int GUI_MANUAL_DIMENSION;
    public static final int GUI_DIMLET_WORKBENCH;
    public static final int GUI_ESSENCE_PAINTER;
    public static CreativeTabs tabRfToolsDim;
    public static final String SHIFT_MESSAGE = "<Press Shift>";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preInit(e);
        MainCompatHandler.registerWaila();
        MainCompatHandler.registerTOP();
        FMLInterModComms.sendFunctionMessage((String)"rftools", (String)"getTeleportationManager", (String)"mcjty.rftoolsdim.RFToolsDim$GetTeleportationManager");
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"mcjty.rftoolsdim.theoneprobe.TheOneProbeSupport");
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            String mod;
            Optional value;
            if ("getDimletConfigurationManager".equalsIgnoreCase(message.key)) {
                value = message.getFunctionValue(IDimletConfigurationManager.class, Void.class);
                mod = message.getSender();
                Logging.log((String)("Received RFTools Dimensions dimlet reconfiguration request from mod '" + mod + "'"));
                ((java.util.function.Function)value.get()).apply(new DimletConfigurationManager(mod));
                continue;
            }
            if (!"getDimensionManager".equalsIgnoreCase(message.key)) continue;
            value = message.getFunctionValue(IDimensionManager.class, Void.class);
            mod = message.getSender();
            Logging.log((String)("Received RFTools dimension manager request from mod '" + mod + "'"));
            ((java.util.function.Function)value.get()).apply(new DimensionManager());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        chisel = Loader.isModLoaded((String)"chisel");
        channels = NetworkRegistry.INSTANCE.newChannel("RFToolsChannel", new ChannelHandler[]{DimensionSyncChannelHandler.instance});
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandRftDim());
        event.registerServerCommand((ICommand)new CommandRftDb());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        Logging.log((String)"RFTools: server is starting");
        ModDimensions.initDimensions();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Logging.log((String)"RFTools: server is stopping. Shutting down gracefully");
        RfToolsDimensionManager.cleanupDimensionInformation();
        RfToolsDimensionManager.clearInstance();
        DimensionStorage.clearInstance();
        KnownDimletConfiguration.init();
        DimletRandomizer.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    public String getModId() {
        return MODID;
    }

    public void openManual(EntityPlayer player, int bookIndex, String page) {
        player.openGui((Object)instance, bookIndex, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    static {
        chisel = false;
        modGuiIndex = 0;
        GUI_DIMENSION_ENSCRIBER = modGuiIndex++;
        GUI_DIMENSION_BUILDER = modGuiIndex++;
        GUI_DIMENSION_EDITOR = modGuiIndex++;
        GUI_MANUAL_DIMENSION = modGuiIndex++;
        GUI_DIMLET_WORKBENCH = modGuiIndex++;
        GUI_ESSENCE_PAINTER = modGuiIndex++;
        tabRfToolsDim = new CreativeTabs("RfToolsDim"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ModItems.realizedDimensionTabItem);
            }
        };
    }

    public static class GetTeleportationManager
    implements Function<ITeleportationManager, Void> {
        @Nullable
        public Void apply(ITeleportationManager manager) {
            teleportationManager = manager;
            return null;
        }
    }
}

