/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityDrawersStandard
extends TileEntityDrawers {
    @CapabilityInject(value=IDrawerAttributes.class)
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;
    private static final String[] GUI_IDS = new String[]{null, "storagedrawers:basicDrawers1", "storagedrawers:basicDrawers2", null, "storagedrawers:basicDrawers4"};
    private int capacity = 0;

    public static TileEntityDrawersStandard createEntity(int slotCount) {
        switch (slotCount) {
            case 1: {
                return new Slot1();
            }
            case 2: {
                return new Slot2();
            }
            case 4: {
                return new Slot4();
            }
        }
        return null;
    }

    @Override
    public IDrawerGroup getGroup() {
        return null;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        switch (this.getDrawerCount()) {
            case 1: {
                return new ContainerDrawers1(playerInventory, this);
            }
            case 2: {
                return new ContainerDrawers2(playerInventory, this);
            }
            case 4: {
                return new ContainerDrawers4(playerInventory, this);
            }
        }
        return null;
    }

    public String func_174875_k() {
        return GUI_IDS[this.getDrawerCount()];
    }

    @Override
    public int getDrawerCapacity() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return super.getDrawerCapacity();
        }
        if (this.capacity == 0) {
            IBlockState blockState = this.func_145831_w().func_180495_p(this.field_174879_c);
            if (!blockState.func_177227_a().contains(BlockStandardDrawers.BLOCK)) {
                return 1;
            }
            EnumBasicDrawer type = (EnumBasicDrawer)((Object)blockState.func_177229_b(BlockStandardDrawers.BLOCK));
            ConfigManager config = StorageDrawers.config;
            switch (type) {
                case FULL1: {
                    this.capacity = config.getBlockBaseStorage("fulldrawers1");
                    break;
                }
                case FULL2: {
                    this.capacity = config.getBlockBaseStorage("fulldrawers2");
                    break;
                }
                case FULL4: {
                    this.capacity = config.getBlockBaseStorage("fulldrawers4");
                    break;
                }
                case HALF2: {
                    this.capacity = config.getBlockBaseStorage("halfdrawers2");
                    break;
                }
                case HALF4: {
                    this.capacity = config.getBlockBaseStorage("halfdrawers4");
                    break;
                }
                default: {
                    this.capacity = 1;
                }
            }
            if (this.capacity <= 0) {
                this.capacity = 1;
            }
        }
        return this.capacity;
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        @Override
        protected int getStackCapacity() {
            return TileEntityDrawersStandard.this.upgrades().getStorageMultiplier() * TileEntityDrawersStandard.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (TileEntityDrawersStandard.this.func_145831_w() != null && !TileEntityDrawersStandard.this.func_145831_w().field_72995_K) {
                TileEntityDrawersStandard.this.func_70296_d();
                TileEntityDrawersStandard.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (TileEntityDrawersStandard.this.func_145831_w() != null && !TileEntityDrawersStandard.this.func_145831_w().field_72995_K) {
                TileEntityDrawersStandard.this.syncClientCount(this.slot, this.getStoredItemCount());
                TileEntityDrawersStandard.this.func_70296_d();
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        @Nonnull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == DRAWER_ATTRIBUTES_CAPABILITY || super.hasCapability(capability, facing);
        }

        @Override
        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return (T)TileEntityDrawersStandard.this.getDrawerAttributes();
            }
            return super.getCapability(capability, facing);
        }
    }

    public static class Legacy
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(4);

        public Legacy() {
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            this.groupData.syncAttributes();
        }

        public void replaceWithCurrent() {
            TileEntityDrawersStandard replacement = Legacy.createEntity(this.groupData.getDrawerCount());
            if (replacement != null) {
                replacement.deserializeNBT(this.serializeNBT());
                this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)replacement);
                replacement.func_70296_d();
            }
        }

        public void func_145829_t() {
            super.func_145829_t();
            this.func_145831_w().func_180497_b(this.func_174877_v(), (Block)ModBlocks.basicDrawers, 1, 0);
        }

        @Override
        public NBTTagCompound writeToPortableNBT(NBTTagCompound tag) {
            return super.writeToPortableNBT(tag);
        }
    }

    public static class Slot4
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(4);

        public Slot4() {
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(2);

        public Slot2() {
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            this.groupData.syncAttributes();
        }
    }

    public static class Slot1
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(1);

        public Slot1() {
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            this.groupData.syncAttributes();
        }
    }
}

