/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateNBTItemInventory
implements IMessage {
    private BlockPos pos;
    private int slotIndex;
    private NBTTagCompound tagCompound;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos(buf);
        this.slotIndex = buf.readInt();
        this.tagCompound = NetworkTools.readTag(buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos(buf, this.pos);
        buf.writeInt(this.slotIndex);
        NetworkTools.writeTag(buf, this.tagCompound);
    }

    public PacketUpdateNBTItemInventory() {
    }

    public PacketUpdateNBTItemInventory(BlockPos pos, int slotIndex, NBTTagCompound tagCompound) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.tagCompound = tagCompound;
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateNBTItemInventory, IMessage> {
        public IMessage onMessage(PacketUpdateNBTItemInventory message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketUpdateNBTItemInventory message, MessageContext ctx) {
            IInventory inv;
            ItemStack stack;
            World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
            TileEntity te = world.func_175625_s(message.pos);
            if (te instanceof IInventory && !(stack = (inv = (IInventory)te).func_70301_a(message.slotIndex)).func_190926_b()) {
                stack.func_77982_d(message.tagCompound);
            }
        }
    }
}

