/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.base.ModBase;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class McJtyRegister {
    private static final List<MBlock> blocks = new ArrayList<MBlock>();
    private static final List<MItem> items = new ArrayList<MItem>();

    public static void registerLater(Block block, ModBase mod, @Nullable Class<? extends ItemBlock> itemBlockClass, @Nullable Class<? extends TileEntity> tileEntityClass) {
        blocks.add(new MBlock(block, mod, itemBlockClass, tileEntityClass));
    }

    public static void registerLater(Item item, ModBase mod) {
        items.add(new MItem(item, mod));
    }

    public static void registerBlocks(ModBase mod, IForgeRegistry<Block> registry) {
        for (MBlock mBlock : blocks) {
            if (!mBlock.getMod().getModId().equals(mod.getModId())) continue;
            registry.register((IForgeRegistryEntry)mBlock.getBlock());
            if (mBlock.getTileEntityClass() == null) continue;
            GameRegistry.registerTileEntity(mBlock.getTileEntityClass(), (String)(mBlock.getMod().getModId() + "_" + mBlock.getBlock().getRegistryName().func_110623_a()));
        }
    }

    public static void registerItems(ModBase mod, IForgeRegistry<Item> registry) {
        for (MItem item : items) {
            if (!item.getMod().getModId().equals(mod.getModId())) continue;
            registry.register((IForgeRegistryEntry)item.getItem());
        }
        for (MBlock mBlock : blocks) {
            if (mBlock.getItemBlockClass() == null || !mBlock.getMod().getModId().equals(mod.getModId())) continue;
            ItemBlock itemBlock = McJtyRegister.createItemBlock(mBlock.getBlock(), mBlock.getItemBlockClass());
            itemBlock.setRegistryName(mBlock.getBlock().getRegistryName());
            registry.register((IForgeRegistryEntry)itemBlock);
        }
    }

    private static ItemBlock createItemBlock(Block block, Class<? extends ItemBlock> itemBlockClass) {
        try {
            Class[] ctorArgClasses = new Class[]{Block.class};
            Constructor<? extends ItemBlock> itemCtor = itemBlockClass.getConstructor(ctorArgClasses);
            return itemCtor.newInstance(block);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MItem {
        private final Item item;
        private final ModBase mod;

        public MItem(Item item, ModBase mod) {
            this.item = item;
            this.mod = mod;
        }

        public Item getItem() {
            return this.item;
        }

        public ModBase getMod() {
            return this.mod;
        }
    }

    private static class MBlock {
        private final Block block;
        private final ModBase mod;
        private final Class<? extends ItemBlock> itemBlockClass;
        private final Class<? extends TileEntity> tileEntityClass;

        public MBlock(Block block, ModBase mod, Class<? extends ItemBlock> itemBlockClass, Class<? extends TileEntity> tileEntityClass) {
            this.block = block;
            this.mod = mod;
            this.itemBlockClass = itemBlockClass;
            this.tileEntityClass = tileEntityClass;
        }

        public Block getBlock() {
            return this.block;
        }

        public ModBase getMod() {
            return this.mod;
        }

        public Class<? extends ItemBlock> getItemBlockClass() {
            return this.itemBlockClass;
        }

        public Class<? extends TileEntity> getTileEntityClass() {
            return this.tileEntityClass;
        }
    }
}

