/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import betterwithmods.api.FeatureEnabledEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.appleskin.helpers.FoodHelper;

public class BetterWithModsHelper {
    private static int FOOD_VALUE_DIVISOR = 6;
    private static String HC_HUNGER_FEATURE_KEY = "hchunger";
    public static boolean HC_HUNGER_ENABLED = false;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new BetterWithModsHelper());
    }

    @SubscribeEvent
    public void bwmFeatureEnabled(FeatureEnabledEvent event) {
        if (event.getFeature().equals(HC_HUNGER_FEATURE_KEY)) {
            HC_HUNGER_ENABLED = event.isEnabled();
        }
    }

    public static FoodHelper.BasicFoodValues getFoodValuesForDisplay(FoodHelper.BasicFoodValues values) {
        if (HC_HUNGER_ENABLED) {
            return new BWMFoodValues(MathHelper.func_76143_f((double)((double)values.hunger / (double)FOOD_VALUE_DIVISOR)), values.saturationModifier);
        }
        return values;
    }

    public static class BWMFoodValues
    extends FoodHelper.BasicFoodValues {
        public BWMFoodValues(int hunger, float saturationModifier) {
            super(hunger, saturationModifier);
        }

        @Override
        public float getSaturationIncrement() {
            return Math.min(20.0f, this.saturationModifier / 3.0f);
        }
    }
}

