/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.appleskin.ModConfig;
import squeek.appleskin.ModInfo;
import squeek.appleskin.helpers.BetterWithModsHelper;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;

@SideOnly(value=Side.CLIENT)
public class TooltipOverlayHandler {
    private static ResourceLocation modIcons = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_BOTTOM = 3;
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_TOP = -3;
    public static final int TOOLTIP_REAL_WIDTH_OFFSET_RIGHT = 3;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
    }

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        int x;
        String saturationText;
        boolean saturationOverflow;
        boolean shouldShowTooltip;
        ItemStack hoveredStack = event.getStack();
        if (hoveredStack == null || hoveredStack.func_190926_b()) {
            return;
        }
        boolean bl = shouldShowTooltip = ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP && KeyHelper.isShiftKeyDown() || ModConfig.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP;
        if (!shouldShowTooltip) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        if (gui == null) {
            return;
        }
        if (!FoodHelper.isFood(hoveredStack)) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        ScaledResolution scale = new ScaledResolution(mc);
        int toolTipY = event.getY();
        int toolTipX = event.getX();
        int toolTipW = event.getWidth();
        int toolTipH = event.getHeight();
        FoodHelper.BasicFoodValues defaultFoodValues = FoodHelper.getDefaultFoodValues(hoveredStack);
        FoodHelper.BasicFoodValues modifiedFoodValues = FoodHelper.getModifiedFoodValues(hoveredStack, (EntityPlayer)player);
        if ((defaultFoodValues = BetterWithModsHelper.getFoodValuesForDisplay(defaultFoodValues)).equals(modifiedFoodValues = BetterWithModsHelper.getFoodValuesForDisplay(modifiedFoodValues)) && defaultFoodValues.hunger == 0) {
            return;
        }
        int biggestHunger = Math.max(defaultFoodValues.hunger, modifiedFoodValues.hunger);
        float biggestSaturationIncrement = Math.max(defaultFoodValues.getSaturationIncrement(), modifiedFoodValues.getSaturationIncrement());
        int barsNeeded = (int)Math.ceil((float)Math.abs(biggestHunger) / 2.0f);
        int saturationBarsNeeded = (int)Math.max(1.0, Math.ceil(Math.abs(biggestSaturationIncrement) / 2.0f));
        boolean bl2 = saturationOverflow = saturationBarsNeeded > 10;
        String string = saturationOverflow ? (defaultFoodValues.saturationModifier < 0.0f ? -1 : 1) * saturationBarsNeeded + "x " : (saturationText = null);
        if (saturationOverflow) {
            saturationBarsNeeded = 1;
        }
        int toolTipBottomY = toolTipY + toolTipH + 1 + 3;
        int toolTipRightX = toolTipX + toolTipW + 1 + 3;
        boolean shouldDrawBelow = toolTipBottomY + 20 < scale.func_78328_b() - 3;
        int rightX = toolTipRightX - 3;
        int leftX = rightX - Math.max(barsNeeded * 9, saturationBarsNeeded * 6 + (int)((float)mc.field_71466_p.func_78256_a(saturationText) * 0.75f)) - 3;
        int topY = shouldDrawBelow ? toolTipBottomY : toolTipY - 20 + -3;
        int bottomY = topY + 19;
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)(leftX - 1), (int)topY, (int)(rightX + 1), (int)bottomY, (int)-267386864);
        Gui.func_73734_a((int)leftX, (int)(shouldDrawBelow ? bottomY : topY - 1), (int)rightX, (int)(shouldDrawBelow ? bottomY + 1 : topY), (int)-267386864);
        Gui.func_73734_a((int)leftX, (int)topY, (int)rightX, (int)bottomY, (int)0x66FFFFFF);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int startX = x = rightX - 2;
        int y = bottomY - 18;
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        for (int i = 0; i < barsNeeded * 2; i += 2) {
            x -= 9;
            if (modifiedFoodValues.hunger < 0) {
                gui.func_73729_b(x, y, 34, 27, 9, 9);
            } else if (modifiedFoodValues.hunger > defaultFoodValues.hunger && defaultFoodValues.hunger <= i) {
                gui.func_73729_b(x, y, 133, 27, 9, 9);
            } else if (modifiedFoodValues.hunger > i + 1 || defaultFoodValues.hunger == modifiedFoodValues.hunger) {
                gui.func_73729_b(x, y, 16, 27, 9, 9);
            } else if (modifiedFoodValues.hunger == i + 1) {
                gui.func_73729_b(x, y, 124, 27, 9, 9);
            } else {
                gui.func_73729_b(x, y, 34, 27, 9, 9);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            gui.func_73729_b(x, y, defaultFoodValues.hunger - 1 == i ? 115 : 106, 27, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (modifiedFoodValues.hunger <= i) continue;
            gui.func_73729_b(x, y, modifiedFoodValues.hunger - 1 == i ? 61 : 52, 27, 9, 9);
        }
        y += 10;
        x = startX;
        float modifiedSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
        float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(modIcons);
        for (int i = 0; i < saturationBarsNeeded * 2; i += 2) {
            boolean shouldBeFaded;
            float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
            x -= 6;
            boolean bl3 = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
            if (shouldBeFaded) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            gui.func_73729_b(x, y, effectiveSaturationOfBar >= 1.0f ? 21 : ((double)effectiveSaturationOfBar > 0.5 ? 14 : ((double)effectiveSaturationOfBar > 0.25 ? 7 : (effectiveSaturationOfBar > 0.0f ? 0 : 28))), modifiedSaturationIncrement >= 0.0f ? 27 : 34, 7, 7);
            if (!shouldBeFaded) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (saturationText != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            mc.field_71466_p.func_175063_a(saturationText, (float)(x * 4 / 3 - mc.field_71466_p.func_78256_a(saturationText) + 2), (float)(y * 4 / 3 + 1), -65536);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }
}

