/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTeslaCoil;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import com.google.common.base.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class OneProbeHelper
extends IECompatModule
implements Function<ITheOneProbe, Void> {
    @Override
    public void preInit() {
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)this.getClass().getName());
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Nullable
    public Void apply(@Nullable ITheOneProbe input) {
        EnergyInfoProvider energyInfo = new EnergyInfoProvider();
        input.registerProvider((IProbeInfoProvider)energyInfo);
        input.registerProbeConfigProvider((IProbeConfigProvider)energyInfo);
        input.registerProvider((IProbeInfoProvider)new ProcessProvider());
        input.registerProvider((IProbeInfoProvider)new TeslaCoilProvider());
        input.registerProvider((IProbeInfoProvider)new SideConfigProvider());
        input.registerBlockDisplayOverride((IBlockDisplayOverride)new MultiblockDisplayOverride());
        return null;
    }

    public static class MultiblockDisplayOverride
    implements IBlockDisplayOverride {
        public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof TileEntityMultiblockPart) {
                ItemStack stack = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState));
                if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowModName())) {
                    probeInfo.horizontal().item(stack).vertical().itemLabel(stack).text(TextStyleClass.MODNAME + "Immersive Engineering");
                } else {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(stack).itemLabel(stack);
                }
                return true;
            }
            return false;
        }
    }

    public static class SideConfigProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "immersiveengineering:SideConfigInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof IEBlockInterfaces.IConfigurableSides && data.getSideHit() != null) {
                boolean flip = player.func_70093_af();
                EnumFacing side = flip ? data.getSideHit().func_176734_d() : data.getSideHit();
                IEEnums.SideConfig sc = ((IEBlockInterfaces.IConfigurableSides)te).getSideConfig(side.func_176745_a());
                String s = I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide." + (flip ? "opposite" : "facing")), (Object[])new Object[0]) + ": ";
                probeInfo.text(s + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.io." + (sc.ordinal() - 1)), (Object[])new Object[0]));
            }
        }
    }

    public static class TeslaCoilProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "immersiveengineering:TeslaCoilInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof TileEntityTeslaCoil) {
                TileEntityTeslaCoil tc = (TileEntityTeslaCoil)te;
                if (tc.dummy) {
                    te = world.func_175625_s(data.getPos().func_177967_a(tc.facing, -1));
                    if (te instanceof TileEntityTeslaCoil) {
                        tc = (TileEntityTeslaCoil)te;
                    } else {
                        probeInfo.text("<ERROR>");
                        return;
                    }
                }
                probeInfo.text(I18n.func_135052_a((String)("chat.immersiveengineering.info.rsControl." + (tc.redstoneControlInverted ? "invertedOn" : "invertedOff")), (Object[])new Object[0]));
                probeInfo.text(I18n.func_135052_a((String)("chat.immersiveengineering.info.tesla." + (tc.lowPower ? "lowPower" : "highPower")), (Object[])new Object[0]));
            }
        }
    }

    public static class ProcessProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "immersiveengineering:ProcessInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof IEBlockInterfaces.IProcessTile) {
                int[] curTicks = ((IEBlockInterfaces.IProcessTile)te).getCurrentProcessesStep();
                int[] maxTicks = ((IEBlockInterfaces.IProcessTile)te).getCurrentProcessesMax();
                int h = Math.max(4, (int)Math.ceil(12.0f / (float)curTicks.length));
                for (int i = 0; i < curTicks.length; ++i) {
                    if (maxTicks[i] <= 0) continue;
                    float f = (float)curTicks[i] / (float)maxTicks[i] * 100.0f;
                    probeInfo.progress((int)f, 100, probeInfo.defaultProgressStyle().showText(h >= 10).suffix("%").height(h));
                }
            }
        }
    }

    public static class EnergyInfoProvider
    implements IProbeInfoProvider,
    IProbeConfigProvider {
        public String getID() {
            return "immersiveengineering:EnergyInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            int cur = 0;
            int max = 0;
            if (te instanceof IFluxReceiver) {
                cur = ((IFluxReceiver)te).getEnergyStored(null);
                max = ((IFluxReceiver)te).getMaxEnergyStored(null);
            } else if (te instanceof IFluxProvider) {
                cur = ((IFluxProvider)te).getEnergyStored(null);
                max = ((IFluxProvider)te).getMaxEnergyStored(null);
            }
            if (max > 0) {
                probeInfo.progress(cur, max, probeInfo.defaultProgressStyle().suffix("IF").filledColor(-557004).alternateFilledColor(-6729952).borderColor(-12705779).numberFormat(NumberFormat.COMPACT));
            }
        }

        public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        }

        public void getProbeConfig(IProbeConfig config, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof IFluxReceiver || te instanceof IFluxProvider) {
                config.setRFMode(0);
            }
        }
    }
}

