/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.FluidStack;

public class ItemNBTHelper {
    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean hasTag(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).func_74764_b(key);
    }

    public static void remove(ItemStack stack, String key) {
        if (ItemNBTHelper.hasKey(stack, key)) {
            ItemNBTHelper.getTag(stack).func_82580_o(key);
            if (ItemNBTHelper.getTag(stack).func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    public static void setInt(ItemStack stack, String key, int val) {
        ItemNBTHelper.getTag(stack).func_74768_a(key, val);
    }

    public static void modifyInt(ItemStack stack, String key, int mod) {
        ItemNBTHelper.modifyInt(ItemNBTHelper.getTag(stack), key, mod);
    }

    public static void modifyInt(NBTTagCompound tagCompound, String key, int mod) {
        tagCompound.func_74768_a(key, tagCompound.func_74762_e(key) + mod);
    }

    public static int getInt(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74762_e(key) : 0;
    }

    public static void setString(ItemStack stack, String key, String val) {
        ItemNBTHelper.getTag(stack).func_74778_a(key, val);
    }

    public static String getString(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74779_i(key) : "";
    }

    public static void setLong(ItemStack stack, String key, long val) {
        ItemNBTHelper.getTag(stack).func_74772_a(key, val);
    }

    public static long getLong(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74763_f(key) : 0L;
    }

    public static void setIntArray(ItemStack stack, String key, int[] val) {
        ItemNBTHelper.getTag(stack).func_74783_a(key, val);
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74759_k(key) : new int[]{};
    }

    public static void setFloat(ItemStack stack, String key, float val) {
        ItemNBTHelper.getTag(stack).func_74776_a(key, val);
    }

    public static void modifyFloat(NBTTagCompound tagCompound, String key, float mod) {
        tagCompound.func_74776_a(key, tagCompound.func_74760_g(key) + mod);
    }

    public static float getFloat(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74760_g(key) : 0.0f;
    }

    public static void setBoolean(ItemStack stack, String key, boolean val) {
        ItemNBTHelper.getTag(stack).func_74757_a(key, val);
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).func_74767_n(key);
    }

    public static void setTagCompound(ItemStack stack, String key, NBTTagCompound val) {
        ItemNBTHelper.getTag(stack).func_74782_a(key, (NBTBase)val);
    }

    public static NBTTagCompound getTagCompound(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).func_74775_l(key) : new NBTTagCompound();
    }

    public static void setFluidStack(ItemStack stack, String key, FluidStack val) {
        if (val != null && val.getFluid() != null) {
            NBTTagCompound tag = ItemNBTHelper.getTagCompound(stack, key);
            ItemNBTHelper.setTagCompound(stack, "Fluid", val.writeToNBT(new NBTTagCompound()));
        } else {
            ItemNBTHelper.remove(stack, "Fluid");
        }
    }

    public static FluidStack getFluidStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack)) {
            NBTTagCompound tag = ItemNBTHelper.getTagCompound(stack, key);
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Fluid"));
        }
        return null;
    }

    public static void setItemStack(ItemStack stack, String key, ItemStack val) {
        ItemNBTHelper.getTag(stack).func_74782_a(key, (NBTBase)val.func_77955_b(new NBTTagCompound()));
    }

    public static ItemStack getItemStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).func_74764_b(key)) {
            return new ItemStack(ItemNBTHelper.getTagCompound(stack, key));
        }
        return ItemStack.field_190927_a;
    }

    public static void setLore(ItemStack stack, String ... lore) {
        NBTTagCompound displayTag = ItemNBTHelper.getTagCompound(stack, "display");
        NBTTagList list = new NBTTagList();
        for (String s : lore) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        displayTag.func_74782_a("Lore", (NBTBase)list);
        ItemNBTHelper.setTagCompound(stack, "display", displayTag);
    }

    public static int insertFluxItem(ItemStack container, int energy, int maxEnergy, boolean simulate) {
        int stored = ItemNBTHelper.getFluxStoredInItem(container);
        int accepted = Math.min(energy, maxEnergy - stored);
        if (!simulate) {
            ItemNBTHelper.setInt(container, "energy", stored += accepted);
        }
        return accepted;
    }

    public static int extractFluxFromItem(ItemStack container, int energy, boolean simulate) {
        int stored = ItemNBTHelper.getFluxStoredInItem(container);
        int extracted = Math.min(energy, stored);
        if (!simulate) {
            ItemNBTHelper.setInt(container, "energy", stored -= extracted);
        }
        return extracted;
    }

    public static int getFluxStoredInItem(ItemStack container) {
        return ItemNBTHelper.getInt(container, "energy");
    }

    public static ItemStack stackWithData(ItemStack stack, Object ... data) {
        assert (data.length % 2 == 0);
        for (int i = 0; i < data.length / 2; ++i) {
            Object key = data[i];
            Object value = data[i + 1];
            if (!(key instanceof String)) continue;
            if (value instanceof Boolean) {
                ItemNBTHelper.setBoolean(stack, (String)key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                ItemNBTHelper.setInt(stack, (String)key, (Integer)value);
                continue;
            }
            if (value instanceof Float) {
                ItemNBTHelper.setFloat(stack, (String)key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Long) {
                ItemNBTHelper.setLong(stack, (String)key, (Long)value);
                continue;
            }
            if (value instanceof String) {
                ItemNBTHelper.setString(stack, (String)key, (String)value);
                continue;
            }
            if (value instanceof NBTTagCompound) {
                ItemNBTHelper.setTagCompound(stack, (String)key, (NBTTagCompound)value);
                continue;
            }
            if (value instanceof int[]) {
                ItemNBTHelper.setIntArray(stack, (String)key, (int[])value);
                continue;
            }
            if (value instanceof ItemStack) {
                ItemNBTHelper.setItemStack(stack, (String)key, (ItemStack)value);
                continue;
            }
            if (!(value instanceof FluidStack)) continue;
            ItemNBTHelper.setFluidStack(stack, (String)key, (FluidStack)value);
        }
        return stack;
    }

    public static NBTTagCompound combineTags(NBTTagCompound target, NBTTagCompound add, Pattern pattern) {
        if (target == null || target.func_82582_d()) {
            return add.func_74737_b();
        }
        for (String key : add.func_150296_c()) {
            if (pattern != null && !pattern.matcher(key).matches()) continue;
            if (!target.func_74764_b(key)) {
                target.func_74782_a(key, add.func_74781_a(key));
                continue;
            }
            switch (add.func_150299_b(key)) {
                case 1: {
                    target.func_74774_a(key, (byte)(target.func_74771_c(key) + add.func_74771_c(key)));
                    break;
                }
                case 2: {
                    target.func_74777_a(key, (short)(target.func_74765_d(key) + add.func_74765_d(key)));
                    break;
                }
                case 3: {
                    target.func_74768_a(key, target.func_74762_e(key) + add.func_74762_e(key));
                    break;
                }
                case 4: {
                    target.func_74772_a(key, target.func_74763_f(key) + add.func_74763_f(key));
                    break;
                }
                case 5: {
                    target.func_74776_a(key, target.func_74760_g(key) + add.func_74760_g(key));
                    break;
                }
                case 6: {
                    target.func_74780_a(key, target.func_74769_h(key) + add.func_74769_h(key));
                    break;
                }
                case 7: {
                    byte[] bytesTarget = target.func_74770_j(key);
                    byte[] bytesAdd = add.func_74770_j(key);
                    byte[] bytes = new byte[bytesTarget.length + bytesAdd.length];
                    System.arraycopy(bytesTarget, 0, bytes, 0, bytesTarget.length);
                    System.arraycopy(bytesAdd, 0, bytes, bytesTarget.length, bytesAdd.length);
                    target.func_74773_a(key, bytes);
                    break;
                }
                case 8: {
                    target.func_74778_a(key, target.func_74779_i(key) + add.func_74779_i(key));
                    break;
                }
                case 9: {
                    NBTTagList listTarget = (NBTTagList)target.func_74781_a(key);
                    NBTTagList listAdd = (NBTTagList)add.func_74781_a(key);
                    for (int i = 0; i < listAdd.func_74745_c(); ++i) {
                        listTarget.func_74742_a(listAdd.func_179238_g(i));
                    }
                    target.func_74782_a(key, (NBTBase)listTarget);
                    break;
                }
                case 10: {
                    ItemNBTHelper.combineTags(target.func_74775_l(key), add.func_74775_l(key), null);
                    break;
                }
                case 11: {
                    int[] intsTarget = target.func_74759_k(key);
                    int[] intsAdd = add.func_74759_k(key);
                    int[] ints = new int[intsTarget.length + intsAdd.length];
                    System.arraycopy(intsTarget, 0, ints, 0, intsTarget.length);
                    System.arraycopy(intsAdd, 0, ints, intsTarget.length, intsAdd.length);
                    target.func_74783_a(key, ints);
                }
            }
        }
        return target;
    }
}

