/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import blusunrize.immersiveengineering.common.util.IEFluid;
import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class EntityChemthrowerShot
extends EntityIEProjectile {
    private FluidStack fluid;
    private static final DataParameter<Optional<FluidStack>> dataMarker_fluid = EntityDataManager.func_187226_a(EntityChemthrowerShot.class, IEFluid.OPTIONAL_FLUID_STACK);

    public EntityChemthrowerShot(World world) {
        super(world);
    }

    public EntityChemthrowerShot(World world, double x, double y, double z, double ax, double ay, double az, FluidStack fluid) {
        super(world, x, y, z, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    public EntityChemthrowerShot(World world, EntityLivingBase living, double ax, double ay, double az, FluidStack fluid) {
        super(world, living, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarker_fluid, (Object)Optional.absent());
    }

    public void setFluidSynced() {
        if (this.getFluid() != null) {
            this.field_70180_af.func_187227_b(dataMarker_fluid, (Object)Optional.of((Object)this.getFluid()));
        }
    }

    public FluidStack getFluidSynced() {
        return (FluidStack)((Optional)this.field_70180_af.func_187225_a(dataMarker_fluid)).orNull();
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public double getGravity() {
        if (this.getFluid() != null) {
            FluidStack fluidStack = this.getFluid();
            boolean isGas = fluidStack.getFluid().isGaseous(fluidStack) || ChemthrowerHandler.isGas(fluidStack.getFluid());
            return (isGas ? 0.025f : 0.05f) * (float)(fluidStack.getFluid().getDensity(fluidStack) < 0 ? -1 : 1);
        }
        return super.getGravity();
    }

    @Override
    public boolean canIgnite() {
        return ChemthrowerHandler.isFlammable(this.getFluid() == null ? null : this.getFluid().getFluid());
    }

    public void func_70030_z() {
        IBlockState state;
        Block b;
        if (this.getFluid() == null && this.field_70170_p.field_72995_K) {
            this.fluid = this.getFluidSynced();
        }
        if ((b = (state = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))).func_177230_c()) != null && this.canIgnite() && (state.func_185904_a() == Material.field_151581_o || state.func_185904_a() == Material.field_151587_i)) {
            this.func_70015_d(6);
        }
        super.func_70030_z();
    }

    public void func_70015_d(int seconds) {
        if (!this.canIgnite()) {
            return;
        }
        super.func_70015_d(seconds);
    }

    @Override
    public void onImpact(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && this.getFluid() != null) {
            int tempDiff;
            int damage;
            boolean fire;
            FluidStack fluidStack = this.getFluid();
            Fluid fluid = fluidStack.getFluid();
            ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect(fluid);
            boolean bl = fire = fluid.getTemperature(fluidStack) > 1000;
            if (effect != null) {
                ItemStack thrower = ItemStack.field_190927_a;
                EntityPlayer shooter = (EntityPlayer)this.getShooter();
                if (shooter != null) {
                    thrower = shooter.func_184586_b(EnumHand.MAIN_HAND);
                }
                if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
                    effect.applyToEntity((EntityLivingBase)mop.field_72308_g, shooter, thrower, fluidStack);
                } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                    effect.applyToBlock(this.field_70170_p, mop, shooter, thrower, fluidStack);
                }
            } else if (mop.field_72308_g != null && fluid.getTemperature(fluidStack) > 500 && mop.field_72308_g.func_70097_a(DamageSource.field_76371_c, (float)(damage = Math.abs(tempDiff = fluid.getTemperature(fluidStack) - 300) / 500))) {
                mop.field_72308_g.field_70172_ad = (int)((double)mop.field_72308_g.field_70172_ad * 0.75);
            }
            if (mop.field_72308_g != null) {
                int f;
                int n = this.func_70027_ad() ? this.field_190534_ay : (f = fire ? 3 : 0);
                if (f > 0) {
                    mop.field_72308_g.func_70015_d(f);
                    if (mop.field_72308_g.func_70097_a(DamageSource.field_76372_a, 2.0f)) {
                        mop.field_72308_g.field_70172_ad = (int)((double)mop.field_72308_g.field_70172_ad * 0.75);
                    }
                }
            }
        }
    }
}

