/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDevice0;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityFluidSorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntitySorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityTurntable;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenBarrel;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import blusunrize.immersiveengineering.common.entities.EntityIEExplosive;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWoodenDevice0
extends BlockIETileProvider<BlockTypes_WoodenDevice0> {
    boolean isExploding = false;

    public BlockWoodenDevice0() {
        super("wooden_device0", Material.field_151575_d, PropertyEnum.func_177709_a((String)"type", BlockTypes_WoodenDevice0.class), ItemBlockIEBase.class, new Object[]{IEProperties.FACING_ALL, IEProperties.SIDECONFIG[0], IEProperties.SIDECONFIG[1], IEProperties.MULTIBLOCKSLAVE});
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setMetaLightOpacity(BlockTypes_WoodenDevice0.WORKBENCH.getMeta(), 0);
        this.setNotNormalBlock(BlockTypes_WoodenDevice0.WORKBENCH.getMeta());
    }

    @Override
    protected EnumFacing getDefaultFacing() {
        return EnumFacing.UP;
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == BlockTypes_WoodenDevice0.WORKBENCH.getMeta()) {
            return "workbench";
        }
        if (Config.seaonal_festive && (meta == BlockTypes_WoodenDevice0.CRATE.getMeta() || meta == BlockTypes_WoodenDevice0.REINFORCED_CRATE.getMeta() || meta == BlockTypes_WoodenDevice0.GUNPOWDER_BARREL.getMeta())) {
            return "festive";
        }
        return null;
    }

    public int getExplosivesType(IBlockState state) {
        if (!state.func_177227_a().contains(this.property)) {
            return -1;
        }
        if (state.func_177229_b((IProperty)this.property) == BlockTypes_WoodenDevice0.GUNPOWDER_BARREL) {
            return 0;
        }
        return -1;
    }

    public void doExplosion(World world, BlockPos pos, IBlockState state, EntityLivingBase igniter, int explosivesType) {
        if (!world.field_72995_K && explosivesType == 0) {
            EntityIEExplosive explosive = new EntityIEExplosive(world, pos, igniter, state, 4.0f).setDropChance(1.0f);
            world.func_72838_d((Entity)explosive);
            world.func_184148_a(null, explosive.field_70165_t, explosive.field_70163_u, explosive.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_175698_g(pos);
        }
    }

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        EnumFacing f;
        return stack.func_77952_i() != BlockTypes_WoodenDevice0.WORKBENCH.getMeta() || !((f = EnumFacing.func_176733_a((double)player.field_70177_z)).func_176740_k() == EnumFacing.Axis.Z ? !world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(1, 0, 0)) && !world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(-1, 0, 0)) : !world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, 0, 1)) && !world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, 0, -1)));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item item;
        ItemStack stack = player.func_184586_b(hand);
        int explosivesType = this.getExplosivesType(state);
        if (!(explosivesType < 0 || stack.func_190926_b() || (item = stack.func_77973_b()) != Items.field_151033_d && item != Items.field_151059_bz)) {
            this.doExplosion(world, pos, state, (EntityLivingBase)player, explosivesType);
            if (item == Items.field_151033_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            } else if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean func_149659_a(Explosion explosionIn) {
        this.isExploding = true;
        return super.func_149659_a(explosionIn);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!this.isExploding || this.getExplosivesType(state) < 0) {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
        this.isExploding = false;
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        if (this.func_176201_c(world.func_180495_p(pos)) == BlockTypes_WoodenDevice0.REINFORCED_CRATE.getMeta()) {
            return 1200000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        int explosivesType = this.getExplosivesType(world.func_180495_p(pos));
        if (world instanceof World && explosivesType >= 0 && world.func_175640_z(pos)) {
            this.doExplosion(world, pos, world.func_180495_p(pos), null, explosivesType);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        int explosivesType = this.getExplosivesType(state);
        if (explosivesType >= 0 && world.func_175640_z(pos)) {
            this.doExplosion(world, pos, state, null, explosivesType);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosionIn) {
        int explosivesType = this.getExplosivesType(world.func_180495_p(pos));
        if (explosivesType >= 0) {
            this.doExplosion(world, pos, world.func_180495_p(pos), null, explosivesType);
        }
        super.onBlockExploded(world, pos, explosionIn);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        int explosivesType = this.getExplosivesType(state);
        if (!world.field_72995_K && entity instanceof EntityArrow && entity.func_70027_ad() && explosivesType >= 0) {
            this.doExplosion(world, pos, state, ((EntityArrow)entity).field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)((EntityArrow)entity).field_70250_c : null, explosivesType);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (BlockTypes_WoodenDevice0.values()[meta]) {
            case CRATE: {
                return new TileEntityWoodenCrate();
            }
            case WORKBENCH: {
                return new TileEntityModWorkbench();
            }
            case BARREL: {
                return new TileEntityWoodenBarrel();
            }
            case SORTER: {
                return new TileEntitySorter();
            }
            case REINFORCED_CRATE: {
                return new TileEntityWoodenCrate();
            }
            case TURNTABLE: {
                return new TileEntityTurntable();
            }
            case FLUID_SORTER: {
                return new TileEntityFluidSorter();
            }
        }
        return null;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }
}

