/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.varia;

import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;

public class RFToolsTools {
    public static void logDebug(String name, BlockPos pos, String info) {
        if (Logging.debugMode) {
            Logging.logDebug((String)(BlockPosTools.toString((BlockPos)pos) + ": " + name + " -> " + info));
        }
    }

    public static boolean hasItemCapabilitySafe(TileEntity tileEntity) {
        try {
            return tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        catch (Exception e) {
            RFToolsTools.reportWrongBlock(tileEntity, e);
            return false;
        }
    }

    public static IItemHandler getItemCapabilitySafe(TileEntity tileEntity) {
        try {
            return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        catch (Exception e) {
            RFToolsTools.reportWrongBlock(tileEntity, e);
            return null;
        }
    }

    public static IFluidHandler hasFluidCapabilitySafe(TileEntity tileEntity) {
        try {
            if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IFluidHandler capability = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (capability == null) {
                    RFToolsTools.reportWrongBlock(tileEntity, null);
                }
                return capability;
            }
            return null;
        }
        catch (Exception e) {
            RFToolsTools.reportWrongBlock(tileEntity, e);
            return null;
        }
    }

    public static IFluidHandler getFluidCapabilitySafe(TileEntity tileEntity) {
        try {
            return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        }
        catch (Exception e) {
            RFToolsTools.reportWrongBlock(tileEntity, e);
            return null;
        }
    }

    private static void reportWrongBlock(TileEntity tileEntity, Exception e) {
        if (tileEntity != null) {
            ResourceLocation name = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v()).func_177230_c().getRegistryName();
            Logging.logError((String)("Block " + name.toString() + " at " + BlockPosTools.toString((BlockPos)tileEntity.func_174877_v()) + " does not respect the capability API and crashes on null side."));
            Logging.logError((String)"Please report to the corresponding mod. This is not a bug in RFTools!");
        }
        if (e != null) {
            Logging.logError((String)"Exception", (Throwable)e);
        }
    }

    public static boolean safeEquals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean chunkLoaded(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        return world.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) != null && world.func_175726_f(pos).func_177410_o();
    }

    public static StringBuffer appendIndent(StringBuffer buffer, int indent) {
        return buffer.append(StringUtils.repeat((char)' ', (int)indent));
    }

    public static void convertNBTtoJson(StringBuffer buffer, NBTTagList tagList, int indent) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            RFToolsTools.appendIndent(buffer, indent).append("{\n");
            RFToolsTools.convertNBTtoJson(buffer, compound, indent + 4);
            RFToolsTools.appendIndent(buffer, indent).append("},\n");
        }
    }

    public static void convertNBTtoJson(StringBuffer buffer, NBTTagCompound tagCompound, int indent) {
        boolean first = true;
        for (Object o : tagCompound.func_150296_c()) {
            if (!first) {
                buffer.append(",\n");
            }
            first = false;
            String key = (String)o;
            NBTBase tag = tagCompound.func_74781_a(key);
            RFToolsTools.appendIndent(buffer, indent).append(key).append(':');
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)tag;
                buffer.append("{\n");
                RFToolsTools.convertNBTtoJson(buffer, compound, indent + 4);
                RFToolsTools.appendIndent(buffer, indent).append('}');
                continue;
            }
            if (tag instanceof NBTTagList) {
                NBTTagList list = (NBTTagList)tag;
                buffer.append("[\n");
                RFToolsTools.convertNBTtoJson(buffer, list, indent + 4);
                RFToolsTools.appendIndent(buffer, indent).append(']');
                continue;
            }
            buffer.append(tag);
        }
        if (!first) {
            buffer.append("\n");
        }
    }

    public static String getModidForBlock(Block block) {
        ResourceLocation nameForObject = block.getRegistryName();
        if (nameForObject == null) {
            return "?";
        }
        return nameForObject.func_110624_b();
    }

    public static boolean hasModuleTarget(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74764_b("monitorx");
    }

    public static int getDimensionFromModule(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("monitordim");
    }

    public static void setPositionInModule(ItemStack stack, Integer dimension, BlockPos pos, String name) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (dimension != null) {
            stack.func_77978_p().func_74768_a("monitordim", dimension.intValue());
        }
        if (name != null) {
            stack.func_77978_p().func_74778_a("monitorname", name);
        }
        stack.func_77978_p().func_74768_a("monitorx", pos.func_177958_n());
        stack.func_77978_p().func_74768_a("monitory", pos.func_177956_o());
        stack.func_77978_p().func_74768_a("monitorz", pos.func_177952_p());
    }

    public static void clearPositionInModule(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        tagCompound.func_82580_o("monitordim");
        tagCompound.func_82580_o("monitorx");
        tagCompound.func_82580_o("monitory");
        tagCompound.func_82580_o("monitorz");
        tagCompound.func_82580_o("monitorname");
    }

    public static BlockPos getPositionFromModule(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        int monitorx = tagCompound.func_74762_e("monitorx");
        int monitory = tagCompound.func_74762_e("monitory");
        int monitorz = tagCompound.func_74762_e("monitorz");
        return new BlockPos(monitorx, monitory, monitorz);
    }
}

