/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items;

import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftools.GeneralConfiguration;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.varia.EntityTools;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SyringeItem
extends GenericRFToolsItem {
    public SyringeItem() {
        super("syringe");
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 5; ++i) {
            String domain = this.getRegistryName().func_110624_b();
            String path = this.getRegistryName().func_110623_a();
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation(domain, path + i), "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                NBTTagCompound tagCompound = stack.func_77978_p();
                int level = 0;
                if (tagCompound != null) {
                    level = tagCompound.func_74762_e("level");
                }
                level = level <= 0 ? 0 : (level >= GeneralConfiguration.maxMobInjections ? 5 : (level - 1) * 4 / (GeneralConfiguration.maxMobInjections - 1) + 1);
                String domain = SyringeItem.this.getRegistryName().func_110624_b();
                String path = SyringeItem.this.getRegistryName().func_110623_a();
                return new ModelResourceLocation(new ResourceLocation(domain, path + level), "inventory");
            }
        });
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                String mobName = SyringeItem.getMobName(stack);
                if (mobName != null) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.BLUE + "Mob: " + mobName));
                }
                int level = tagCompound.func_74762_e("level");
                level = level * 100 / GeneralConfiguration.maxMobInjections;
                Logging.message((EntityPlayer)player, (String)(TextFormatting.BLUE + "Essence level: " + level + "%"));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        Class<? extends Entity> clazz = this.findSelectedMobClass(entity);
        if (clazz != null) {
            String prevMobId = null;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                prevMobId = EntityTools.fixEntityId(tagCompound.func_74779_i("mobId"));
            } else {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            String id = this.findSelectedMobId(clazz, entity);
            if (id != null && !id.isEmpty()) {
                if (prevMobId == null || !prevMobId.equals(id)) {
                    tagCompound.func_74778_a("mobName", this.findSelectedMobName(entity));
                    tagCompound.func_74778_a("mobId", id);
                    tagCompound.func_74768_a("level", 1);
                } else {
                    int level = tagCompound.func_74762_e("level");
                    if (++level > GeneralConfiguration.maxMobInjections) {
                        level = GeneralConfiguration.maxMobInjections;
                    }
                    tagCompound.func_74768_a("level", level);
                }
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private String findSelectedMobId(Class<? extends Entity> clazz, Entity entity) {
        return EntityList.func_191306_a(clazz).toString();
    }

    private Class<? extends Entity> findSelectedMobClass(Entity entity) {
        Class<?> entityClass = entity.getClass();
        return entityClass;
    }

    private String findSelectedMobName(Entity entity) {
        return entity.func_70005_c_();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String mobName = SyringeItem.getMobName(itemStack);
            if (mobName != null) {
                list.add(TextFormatting.BLUE + "Mob: " + mobName);
            }
            int level = tagCompound.func_74762_e("level");
            level = level * 100 / GeneralConfiguration.maxMobInjections;
            list.add(TextFormatting.BLUE + "Essence level: " + level + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Use this to extract essence from mobs");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public static ItemStack createMobSyringe(Class<? extends Entity> mobClass) {
        String id = EntityTools.findEntityIdByClass(mobClass);
        String name = ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id))).getName();
        return SyringeItem.createMobSyringe(id, name);
    }

    private static ItemStack createMobSyringe(String id, String name) {
        ItemStack syringe = new ItemStack((Item)ModItems.syringeItem);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("mobId", id);
        if (name == null || name.isEmpty()) {
            name = id;
        }
        tagCompound.func_74778_a("mobName", name);
        tagCompound.func_74768_a("level", GeneralConfiguration.maxMobInjections);
        syringe.func_77982_d(tagCompound);
        return syringe;
    }

    public static String getMobId(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            String mob = tagCompound.func_74779_i("mobId");
            if (mob == null) {
                return tagCompound.func_74779_i("mobName");
            }
            mob = EntityTools.fixEntityId(mob);
            return mob;
        }
        return null;
    }

    public static String getMobName(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            String mob = tagCompound.func_74779_i("mobName");
            if (mob == null) {
                if (tagCompound.func_74764_b("mobId")) {
                    String mobId = tagCompound.func_74779_i("mobId");
                    mobId = EntityTools.fixEntityId(mobId);
                    return mobId;
                }
                return "?";
            }
            return mob;
        }
        return null;
    }
}

