/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.rftools.blocks.storage.ModularStorageItemInventory;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.items.storage.StorageModuleItem;
import mcjty.rftools.jei.JEIRecipeAcceptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class ModularStorageItemContainer
extends GenericContainer {
    public static final String CONTAINER_INVENTORY = "container";
    public static final String CONTAINER_GRID = "grid";
    private EntityPlayer entityPlayer;
    private int tabletIndex;
    public static final ContainerFactory factory = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_INPUT, new ItemStack[0]), ModularStorageItemContainer.CONTAINER_INVENTORY, 0, -500, -500, 30, 0, 10, 0);
            this.layoutPlayerInventorySlots(91, 157);
            this.layoutGridInventorySlots(CraftingGridInventory.GRID_XOFFSET, CraftingGridInventory.GRID_YOFFSET);
        }

        protected void layoutGridInventorySlots(int leftCol, int topRow) {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]), ModularStorageItemContainer.CONTAINER_GRID, CraftingGridInventory.SLOT_GHOSTINPUT, leftCol, topRow, 3, 18, 3, 18);
            this.addSlotRange(new SlotDefinition(SlotType.SLOT_GHOSTOUT, new ItemStack[0]), ModularStorageItemContainer.CONTAINER_GRID, CraftingGridInventory.SLOT_GHOSTOUTPUT, leftCol, topRow += 58, 1, 18);
        }
    };

    public CraftingGridProvider getCraftingGridProvider() {
        return (CraftingGridProvider)this.getInventory(CONTAINER_INVENTORY);
    }

    public void clearGrid() {
        IInventory inventory = (IInventory)this.inventories.get(CONTAINER_GRID);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public JEIRecipeAcceptor getJEIRecipeAcceptor() {
        return (JEIRecipeAcceptor)this.getInventory(CONTAINER_INVENTORY);
    }

    public ModularStorageItemContainer(EntityPlayer player) {
        super(factory);
        this.entityPlayer = player;
        ModularStorageItemInventory inventory = new ModularStorageItemInventory(player);
        this.addInventory(CONTAINER_INVENTORY, inventory);
        this.addInventory("player", (IInventory)player.field_71071_by);
        this.addInventory(CONTAINER_GRID, inventory.getCraftingGrid().getCraftingGridInventory());
        this.tabletIndex = player.field_71071_by.field_70461_c;
        this.generateSlots();
    }

    private int getMaxSize() {
        return StorageModuleItem.MAXSIZE[this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p().func_74762_e("childDamage")];
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : factory.getSlots()) {
            BaseSlot slot;
            if (CONTAINER_GRID.equals(slotFactory.getInventoryName())) {
                SlotType slotType = slotFactory.getSlotType();
                IInventory inventory = (IInventory)this.inventories.get(slotFactory.getInventoryName());
                int index = slotFactory.getIndex();
                int x = slotFactory.getX();
                int y = slotFactory.getY();
                slot = this.createSlot(slotFactory, inventory, index, x, y, slotType);
            } else {
                slot = slotFactory.getSlotType() == SlotType.SLOT_PLAYERHOTBAR ? (slotFactory.getIndex() == this.tabletIndex ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean func_82869_a(EntityPlayer player) {
                        return false;
                    }
                } : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY())) : (slotFactory.getSlotType() == SlotType.SLOT_PLAYERINV ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()) : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean func_75214_a(ItemStack stack) {
                        return this.getSlotIndex() < ModularStorageItemContainer.this.getMaxSize();
                    }
                });
            }
            this.func_75146_a((Slot)slot);
        }
    }
}

