/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.generator;

import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.compat.RedstoneFluxCompatibility;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyProviderTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.generator.CoalGeneratorConfiguration;
import mcjty.rftools.blocks.generator.CoalGeneratorContainer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CoalGeneratorTileEntity
extends GenericEnergyProviderTileEntity
implements ITickable,
DefaultSidedInventory,
IMachineInformation {
    public static final String CMD_RSMODE = "rsMode";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CoalGeneratorContainer.factory, 2);
    private int burning;

    public CoalGeneratorTileEntity() {
        super(CoalGeneratorConfiguration.MAXENERGY, CoalGeneratorConfiguration.SENDPERTICK);
    }

    public int getEnergyDiffPerTick() {
        return this.burning > 0 ? this.getRfPerTick() : 0;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return this.isMachineEnabled();
    }

    public boolean isMachineRunning() {
        return this.isMachineEnabled();
    }

    @Nullable
    public String getMachineStatus() {
        return this.burning > 0 ? "generating power" : "idle";
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.markDirtyClient();
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            boolean working;
            this.handleChargingItem();
            this.handleSendingEnergy();
            if (!this.isMachineEnabled()) {
                return;
            }
            boolean bl = working = this.burning > 0;
            if (this.burning > 0) {
                --this.burning;
                int rf = this.getRfPerTick();
                this.modifyEnergyStored(rf);
                if (this.burning == 0) {
                    this.markDirtyClient();
                } else {
                    this.func_70296_d();
                }
                return;
            }
            if (this.inventoryHelper.containsItem(0)) {
                ItemStack extracted = this.inventoryHelper.decrStackSize(0, 1);
                this.burning = CoalGeneratorConfiguration.ticksPerCoal;
                if (extracted.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
                    this.burning *= 9;
                }
                this.burning += (int)((float)this.burning * this.getInfusedFactor() / 2.0f);
                if (working) {
                    this.func_70296_d();
                } else {
                    this.markDirtyClient();
                }
            } else if (working) {
                this.markDirtyClient();
            }
        }
    }

    public int getRfPerTick() {
        int rf = CoalGeneratorConfiguration.rfPerTick;
        rf += (int)((float)rf * this.getInfusedFactor());
        return rf;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean newWorking;
        boolean working = this.isWorking();
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K && (newWorking = this.isWorking()) != working) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public boolean isWorking() {
        return this.burning > 0 && this.isMachineEnabled();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    private void handleChargingItem() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(1);
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage capability = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            int energyStored = this.getEnergyStored();
            int rfToGive = CoalGeneratorConfiguration.CHARGEITEMPERTICK <= energyStored ? CoalGeneratorConfiguration.CHARGEITEMPERTICK : energyStored;
            int received = capability.receiveEnergy(rfToGive, false);
            this.storage.extractEnergy(received, false);
        } else if (RFTools.redstoneflux && RedstoneFluxCompatibility.isEnergyItem((Item)stack.func_77973_b())) {
            int energyStored = this.getEnergyStored();
            int rfToGive = CoalGeneratorConfiguration.CHARGEITEMPERTICK <= energyStored ? CoalGeneratorConfiguration.CHARGEITEMPERTICK : energyStored;
            int received = RedstoneFluxCompatibility.receiveEnergy((Item)stack.func_77973_b(), (ItemStack)stack, (int)rfToGive, (boolean)false);
            this.storage.extractEnergy(received, false);
        }
    }

    private void handleSendingEnergy() {
        int energyStored = this.getEnergyStored();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int rfToGive;
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            EnumFacing opposite = facing.func_176734_d();
            if (!EnergyTools.isEnergyTE((TileEntity)te) && (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, opposite))) continue;
            int n = rfToGive = CoalGeneratorConfiguration.SENDPERTICK <= energyStored ? CoalGeneratorConfiguration.SENDPERTICK : energyStored;
            int received = RFTools.redstoneflux && RedstoneFluxCompatibility.isEnergyConnection((TileEntity)te) ? (RedstoneFluxCompatibility.canConnectEnergy((TileEntity)te, (EnumFacing)opposite) ? EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive) : 0) : EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive);
            if ((energyStored -= this.storage.extractEnergy(received, false)) <= 0) break;
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 1) {
            boolean rf = RFTools.redstoneflux && RedstoneFluxCompatibility.isEnergyItem((Item)stack.func_77973_b());
            return rf;
        }
        if (index == 0) {
            return stack.func_77973_b() == Items.field_151044_h || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci);
        }
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.burning = tagCompound.func_74762_e("burning");
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("burning", this.burning);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRSMode(RedstoneMode.getMode((String)m));
            return true;
        }
        return false;
    }
}

