/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class FurnaceManager {
    private static Map<ComparableItemStackFurnace, FurnaceRecipe> recipeMap = new THashMap();
    private static Map<ComparableItemStackFurnace, FurnaceRecipe> recipeMapPyrolysis = new THashMap();
    private static Set<ComparableItemStackFurnace> foodSet = new THashSet();
    private static Set<ComparableItemStackFurnace> oreSet = new THashSet();
    private static Map<String, ItemStack> reservedMap = new THashMap();
    public static final int DEFAULT_ENERGY = 2000;

    public static FurnaceRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackFurnace query = new ComparableItemStackFurnace(input);
        FurnaceRecipe recipe = recipeMap.get((Object)query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get((Object)query);
        }
        return recipe;
    }

    public static FurnaceRecipe getRecipePyrolysis(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackFurnace query = new ComparableItemStackFurnace(input);
        FurnaceRecipe recipe = recipeMapPyrolysis.get((Object)query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get((Object)query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return FurnaceManager.getRecipe(input) != null;
    }

    public static boolean recipeExistsPyrolysis(ItemStack input) {
        return FurnaceManager.getRecipePyrolysis(input) != null;
    }

    public static FurnaceRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new FurnaceRecipe[recipeMap.size()]);
    }

    public static FurnaceRecipe[] getRecipeListPyrolysis() {
        return recipeMapPyrolysis.values().toArray(new FurnaceRecipe[recipeMapPyrolysis.size()]);
    }

    public static boolean isFood(ItemStack input) {
        if (input.func_190926_b()) {
            return false;
        }
        ComparableItemStackFurnace query = new ComparableItemStackFurnace(input);
        if (foodSet.contains((Object)query)) {
            return true;
        }
        query.metadata = Short.MAX_VALUE;
        return foodSet.contains((Object)query);
    }

    public static boolean isOre(ItemStack input) {
        if (input.func_190926_b()) {
            return false;
        }
        ComparableItemStackFurnace query = new ComparableItemStackFurnace(input);
        if (oreSet.contains((Object)query)) {
            return true;
        }
        query.metadata = Short.MAX_VALUE;
        return oreSet.contains((Object)query);
    }

    public static void initialize() {
        FurnaceManager.addRecipe(1000, new ItemStack((Block)Blocks.field_150434_aF), new ItemStack(Items.field_151100_aR, 1, 2));
        FurnaceManager.addRecipe(4000, new ItemStack(Items.field_151078_bh, 3, 0), new ItemStack(Items.field_151116_aA));
        int energy = 1000;
        FurnaceManager.addRecipe(energy, new ItemStack(Items.field_151147_al, 1, Short.MAX_VALUE), new ItemStack(Items.field_151157_am));
        FurnaceManager.addRecipe(energy, new ItemStack(Items.field_151082_bd, 1, Short.MAX_VALUE), new ItemStack(Items.field_151083_be));
        FurnaceManager.addRecipe(energy, new ItemStack(Items.field_151076_bf, 1, Short.MAX_VALUE), new ItemStack(Items.field_151077_bg));
        FurnaceManager.addRecipe(energy, new ItemStack(Items.field_179561_bm, 1, Short.MAX_VALUE), new ItemStack(Items.field_179557_bn));
        FurnaceManager.addRecipe(energy, new ItemStack(Items.field_179558_bo, 1, Short.MAX_VALUE), new ItemStack(Items.field_179559_bp));
        FurnaceManager.addRecipe(energy, new ItemStack(Items.field_151174_bG, 1, Short.MAX_VALUE), new ItemStack(Items.field_151168_bH));
        FurnaceManager.addRecipe(energy, new ItemStack(Items.field_151115_aP, 1, 0), new ItemStack(Items.field_179566_aV, 1, 0));
        FurnaceManager.addRecipe(energy, new ItemStack(Items.field_151115_aP, 1, 1), new ItemStack(Items.field_179566_aV, 1, 1));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151147_al, 1, Short.MAX_VALUE)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151082_bd, 1, Short.MAX_VALUE)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151076_bf, 1, Short.MAX_VALUE)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_179561_bm, 1, Short.MAX_VALUE)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_179558_bo, 1, Short.MAX_VALUE)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151174_bG, 1, Short.MAX_VALUE)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151115_aP, 1, 0)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151115_aP, 1, 1)));
        energy = 2000;
        FurnaceManager.addOreDictRecipe(energy, "oreIron", ItemMaterial.ingotIron);
        FurnaceManager.addOreDictRecipe(energy, "oreGold", ItemMaterial.ingotGold);
        FurnaceManager.addOreDictRecipe(energy, "oreCopper", ItemMaterial.ingotCopper);
        FurnaceManager.addOreDictRecipe(energy, "oreTin", ItemMaterial.ingotTin);
        FurnaceManager.addOreDictRecipe(energy, "oreSilver", ItemMaterial.ingotSilver);
        FurnaceManager.addOreDictRecipe(energy, "oreLead", ItemMaterial.ingotLead);
        FurnaceManager.addOreDictRecipe(energy, "oreNickel", ItemMaterial.ingotNickel);
        FurnaceManager.addOreDictRecipe(energy, "orePlatinum", ItemMaterial.ingotPlatinum);
        FurnaceManager.addOreDictRecipe(energy, "oreCoal", new ItemStack(Items.field_151044_h, 1, 0));
        FurnaceManager.addOreDictRecipe(energy, "oreDiamond", new ItemStack(Items.field_151045_i, 1, 0));
        FurnaceManager.addOreDictRecipe(energy, "oreEmerald", new ItemStack(Items.field_151166_bC, 1, 0));
        FurnaceManager.addOreDictRecipe(energy, "oreLapis", new ItemStack(Items.field_151100_aR, 6, 4));
        FurnaceManager.addOreDictRecipe(energy, "oreRedstone", new ItemStack(Items.field_151137_ax, 3, 0));
        FurnaceManager.addOreDictRecipe(energy, "oreQuartz", new ItemStack(Items.field_151128_bU, 1, 0));
        energy = 1400;
        FurnaceManager.addOreDictRecipe(energy, "dustIron", ItemMaterial.ingotIron);
        FurnaceManager.addOreDictRecipe(energy, "dustGold", ItemMaterial.ingotGold);
        FurnaceManager.addOreDictRecipe(energy, "dustCopper", ItemMaterial.ingotCopper);
        FurnaceManager.addOreDictRecipe(energy, "dustTin", ItemMaterial.ingotTin);
        FurnaceManager.addOreDictRecipe(energy, "dustSilver", ItemMaterial.ingotSilver);
        FurnaceManager.addOreDictRecipe(energy, "dustLead", ItemMaterial.ingotLead);
        FurnaceManager.addOreDictRecipe(energy, "dustNickel", ItemMaterial.ingotNickel);
        FurnaceManager.addOreDictRecipe(energy, "dustPlatinum", ItemMaterial.ingotPlatinum);
        FurnaceManager.addOreDictRecipe(energy, "dustIridium", ItemMaterial.ingotIridium);
        FurnaceManager.addOreDictRecipe(energy, "dustMithril", ItemMaterial.ingotMithril);
        FurnaceManager.addOreDictRecipe(energy, "dustElectrum", ItemMaterial.ingotElectrum);
        FurnaceManager.addOreDictRecipe(energy, "dustInvar", ItemMaterial.ingotInvar);
        FurnaceManager.addOreDictRecipe(energy, "dustBronze", ItemMaterial.ingotBronze);
        FurnaceManager.addOreDictRecipe(energy, "dustConstantan", ItemMaterial.ingotConstantan);
        energy = 800;
        FurnaceManager.addOreDictRecipe(energy, "oreberryCopper", ItemMaterial.nuggetCopper);
        FurnaceManager.addOreDictRecipe(energy, "oreberryTin", ItemMaterial.nuggetTin);
        FurnaceManager.addOreDictRecipe(energy, "oreberrySilver", ItemMaterial.nuggetSilver);
        FurnaceManager.addOreDictRecipe(energy, "oreberryLead", ItemMaterial.nuggetLead);
        FurnaceManager.addOreDictRecipe(energy, "oreberryAluminum", ItemMaterial.nuggetAluminum);
        FurnaceManager.addOreDictRecipe(energy, "oreberryNickel", ItemMaterial.nuggetNickel);
        FurnaceManager.addOreDictRecipe(energy, "oreberryPlatinum", ItemMaterial.nuggetPlatinum);
        FurnaceManager.addOreDictRecipe(energy, "oreberryIridium", ItemMaterial.nuggetIridium);
        FurnaceManager.addOreDictRecipe(energy, "oreberryMithril", ItemMaterial.nuggetMithril);
        ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);
        FurnaceManager.addRecipePyrolysis(1000, ItemMaterial.dustWoodCompressed, charcoal, 50);
        FurnaceManager.addRecipePyrolysis(1000, new ItemStack(Blocks.field_150364_r), charcoal, 100);
        FurnaceManager.addRecipePyrolysis(1000, new ItemStack(Items.field_151120_aE, 8), charcoal, 50);
        FurnaceManager.addRecipePyrolysis(2000, new ItemStack(Blocks.field_150407_cf), charcoal, 100);
        FurnaceManager.addRecipePyrolysis(2000, new ItemStack((Block)Blocks.field_150434_aF, 4), charcoal, 50);
        FurnaceManager.addRecipePyrolysis(2000, new ItemStack(Items.field_151044_h), ItemMaterial.fuelCoke, 250);
        FurnaceManager.loadRecipes();
    }

    public static void loadRecipes() {
        Map smeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
        THashSet handledBlocks = new THashSet();
        handledBlocks.add(Blocks.field_150434_aF);
        handledBlocks.add(Blocks.field_150352_o);
        handledBlocks.add(Blocks.field_150366_p);
        handledBlocks.add(Blocks.field_150365_q);
        handledBlocks.add(Blocks.field_150482_ag);
        handledBlocks.add(Blocks.field_150412_bA);
        handledBlocks.add(Blocks.field_150369_x);
        handledBlocks.add(Blocks.field_150450_ax);
        handledBlocks.add(Blocks.field_150449_bY);
        reservedMap.put("oreAluminum", ItemMaterial.ingotAluminum);
        reservedMap.put("oreIridium", ItemMaterial.ingotIridium);
        reservedMap.put("oreMithril", ItemMaterial.ingotMithril);
        reservedMap.put("dustAluminum", ItemMaterial.ingotAluminum);
        reservedMap.put("dustIridium", ItemMaterial.ingotIridium);
        reservedMap.put("dustMithril", ItemMaterial.ingotMithril);
        reservedMap.put("dustSteel", ItemMaterial.ingotSteel);
        reservedMap.put("dustSignalum", ItemMaterial.ingotSignalum);
        reservedMap.put("dustLumium", ItemMaterial.ingotLumium);
        reservedMap.put("dustEnderium", ItemMaterial.ingotEnderium);
        for (ItemStack key : smeltingList.keySet()) {
            ItemStack output;
            if (key.func_190926_b() || FurnaceManager.recipeExists(key) || (output = (ItemStack)smeltingList.get(key)).func_190926_b() || handledBlocks.contains(Block.func_149634_a((Item)key.func_77973_b()))) continue;
            if (reservedMap.containsKey(ItemHelper.getOreName((ItemStack)key))) {
                output = ItemHelper.cloneStack((ItemStack)reservedMap.get(ItemHelper.getOreName((ItemStack)key)), (int)output.func_190916_E());
            }
            int energy = 2000;
            if (output.func_77973_b() instanceof ItemFood) {
                foodSet.add(new ComparableItemStackFurnace(key));
                energy /= 2;
            }
            if (ItemHelper.isDust((ItemStack)key) && ItemHelper.isIngot((ItemStack)output)) {
                FurnaceManager.addRecipe(energy * 14 / 20, key, output);
                continue;
            }
            if (ItemHelper.getItemDamage((ItemStack)key) == Short.MAX_VALUE) {
                ItemStack testKey = ItemHelper.cloneStack((ItemStack)key);
                testKey.func_77964_b(0);
                if (ItemHelper.hasOreName((ItemStack)testKey) && ComparableItemStackFurnace.safeOreType(ItemHelper.getOreName((ItemStack)testKey))) {
                    FurnaceManager.addRecipe(energy, testKey, output);
                    continue;
                }
            }
            FurnaceManager.addRecipe(energy, key, output);
        }
    }

    public static void refresh() {
        FurnaceRecipe tempRecipe;
        THashMap tempMap = new THashMap(recipeMap.size());
        THashMap tempMapPyrolysis = new THashMap(recipeMapPyrolysis.size());
        THashSet tempFood = new THashSet();
        THashSet tempOre = new THashSet();
        for (Map.Entry<ComparableItemStackFurnace, FurnaceRecipe> entry : recipeMap.entrySet()) {
            tempRecipe = entry.getValue();
            tempMap.put(new ComparableItemStackFurnace(tempRecipe.input), tempRecipe);
        }
        for (Map.Entry<ComparableItemStackFurnace, FurnaceRecipe> entry : recipeMapPyrolysis.entrySet()) {
            tempRecipe = entry.getValue();
            tempMapPyrolysis.put(new ComparableItemStackFurnace(tempRecipe.input), tempRecipe);
        }
        for (ComparableItemStackFurnace comparableItemStackFurnace : foodSet) {
            ComparableItemStackFurnace food = new ComparableItemStackFurnace(new ItemStack(comparableItemStackFurnace.item, comparableItemStackFurnace.stackSize, comparableItemStackFurnace.metadata));
            tempFood.add(food);
        }
        for (ComparableItemStackFurnace comparableItemStackFurnace : oreSet) {
            ComparableItemStackFurnace ore = new ComparableItemStackFurnace(new ItemStack(comparableItemStackFurnace.item, comparableItemStackFurnace.stackSize, comparableItemStackFurnace.metadata));
            tempOre.add(ore);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        recipeMapPyrolysis.clear();
        recipeMapPyrolysis = tempMapPyrolysis;
        foodSet.clear();
        foodSet = tempFood;
        oreSet.clear();
        oreSet = tempOre;
    }

    public static FurnaceRecipe addRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || FurnaceManager.recipeExists(input)) {
            return null;
        }
        FurnaceRecipe recipe = new FurnaceRecipe(input, output, energy);
        recipeMap.put(new ComparableItemStackFurnace(input), recipe);
        return recipe;
    }

    public static FurnaceRecipe addRecipePyrolysis(int energy, ItemStack input, ItemStack output, int creosote) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || FurnaceManager.recipeExistsPyrolysis(input)) {
            return null;
        }
        FurnaceRecipe recipe = new FurnaceRecipe(input, output, energy, creosote);
        recipeMapPyrolysis.put(new ComparableItemStackFurnace(input), recipe);
        return recipe;
    }

    public static FurnaceRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove((Object)new ComparableItemStackFurnace(input));
    }

    public static FurnaceRecipe removeRecipePyrolysis(ItemStack input) {
        return recipeMapPyrolysis.remove((Object)new ComparableItemStackFurnace(input));
    }

    private static void addOreDictRecipe(int energy, String oreName, ItemStack output) {
        if (ItemHelper.oreNameExists((String)oreName) && !FurnaceManager.recipeExists((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0))) {
            FurnaceManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0)), (int)1), output);
            if (oreName.startsWith("ore") && ItemHelper.isIngot((ItemStack)output)) {
                oreSet.add(new ComparableItemStackFurnace((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0)));
            }
        }
    }

    public static class ComparableItemStackFurnace
    extends ComparableItemStack {
        public static final String ORE = "ore";
        public static final String DUST = "dust";
        public static final String LOG = "log";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(ORE) || oreName.startsWith(DUST) || oreName.startsWith(LOG);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                int i = 0;
                int e = ids.size();
                while (i < e) {
                    int id;
                    if ((id = ((Integer)ids.get(i++)).intValue()) == -1 || !ComparableItemStackFurnace.safeOreType(ItemHelper.oreProxy.getOreName(id))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackFurnace(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackFurnace.getOreID(stack);
        }

        public ComparableItemStackFurnace set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackFurnace.getOreID(stack);
            return this;
        }
    }

    public static class FurnaceRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;
        final int creosote;

        FurnaceRecipe(ItemStack input, ItemStack output, int energy) {
            this(input, output, energy, 0);
        }

        FurnaceRecipe(ItemStack input, ItemStack output, int energy, int creosote) {
            this.input = input;
            this.output = output;
            this.energy = energy;
            this.creosote = creosote;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getCreosote() {
            return this.creosote;
        }
    }
}

