/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalfoundation.block.BlockOreFluid;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleManager {
    private static Map<ComparableItemStackCrucible, CrucibleRecipe> recipeMap = new THashMap();
    private static Set<ComparableItemStackCrucible> lavaSet = new THashSet();
    public static final int DEFAULT_ENERGY = 8000;

    public static CrucibleRecipe getRecipe(ItemStack input) {
        return input.func_190926_b() ? null : recipeMap.get((Object)new ComparableItemStackCrucible(input));
    }

    public static boolean recipeExists(ItemStack input) {
        return CrucibleManager.getRecipe(input) != null;
    }

    public static CrucibleRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new CrucibleRecipe[recipeMap.size()]);
    }

    public static boolean isLava(ItemStack input) {
        return !input.func_190926_b() && lavaSet.contains((Object)new ComparableItemStackCrucible(input));
    }

    public static void initialize() {
        int netherrack_RF = 60000;
        int magma_RF = 40000;
        int rock_RF = 300000;
        CrucibleManager.addRecipe(netherrack_RF, new ItemStack(Blocks.field_150424_aL), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(magma_RF, new ItemStack(Blocks.field_189877_df), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150347_e), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150348_b), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150348_b), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150348_b, 1, 5), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150348_b, 1, 6), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150343_Z), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(200, new ItemStack(Items.field_151126_ay), new FluidStack(FluidRegistry.WATER, 125));
        CrucibleManager.addRecipe(800, new ItemStack(Blocks.field_150433_aE), new FluidStack(FluidRegistry.WATER, 500));
        CrucibleManager.addRecipe(1600, new ItemStack(Blocks.field_150432_aD), new FluidStack(FluidRegistry.WATER, 1000));
        CrucibleManager.addRecipe(8000, new ItemStack(Items.field_151137_ax), new FluidStack(TFFluids.fluidRedstone, 100));
        CrucibleManager.addRecipe(72000, new ItemStack(Blocks.field_150451_bX), new FluidStack(TFFluids.fluidRedstone, 900));
        CrucibleManager.addRecipe(20000, new ItemStack(Items.field_151114_aO), new FluidStack(TFFluids.fluidGlowstone, 250));
        CrucibleManager.addRecipe(80000, new ItemStack(Blocks.field_150426_aN), new FluidStack(TFFluids.fluidGlowstone, 1000));
        CrucibleManager.addRecipe(20000, new ItemStack(Items.field_151079_bi), new FluidStack(TFFluids.fluidEnder, 250));
        CrucibleManager.addRecipe(2000, ItemMaterial.globTar, new FluidStack(TFFluids.fluidCreosote, 100));
        CrucibleManager.addRecipe(4000, ItemMaterial.dustCoal, new FluidStack(TFFluids.fluidCoal, 100));
        CrucibleManager.addRecipe(2000, ItemMaterial.crystalCrudeOil, new FluidStack(TFFluids.fluidCrudeOil, 250));
        CrucibleManager.addRecipe(2000, ItemMaterial.crystalRedstone, new FluidStack(TFFluids.fluidRedstone, 250));
        CrucibleManager.addRecipe(2000, ItemMaterial.crystalGlowstone, new FluidStack(TFFluids.fluidGlowstone, 250));
        CrucibleManager.addRecipe(2000, ItemMaterial.crystalEnder, new FluidStack(TFFluids.fluidEnder, 250));
        CrucibleManager.addRecipe(8000, ItemMaterial.dustPyrotheum, new FluidStack(TFFluids.fluidPyrotheum, 250));
        CrucibleManager.addRecipe(8000, ItemMaterial.dustCryotheum, new FluidStack(TFFluids.fluidCryotheum, 250));
        CrucibleManager.addRecipe(8000, ItemMaterial.dustAerotheum, new FluidStack(TFFluids.fluidAerotheum, 250));
        CrucibleManager.addRecipe(8000, ItemMaterial.dustPetrotheum, new FluidStack(TFFluids.fluidPetrotheum, 250));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidCrudeOilSand, new FluidStack(TFFluids.fluidCrudeOil, 1000));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidCrudeOilGravel, new FluidStack(TFFluids.fluidCrudeOil, 1000));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidRedstone, new FluidStack(TFFluids.fluidRedstone, 1000));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidGlowstone, new FluidStack(TFFluids.fluidGlowstone, 1000));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidEnder, new FluidStack(TFFluids.fluidEnder, 1000));
        CrucibleManager.loadRecipes();
    }

    public static void loadRecipes() {
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<ComparableItemStackCrucible, CrucibleRecipe> entry : recipeMap.entrySet()) {
            CrucibleRecipe tempRecipe = entry.getValue();
            ComparableItemStackCrucible input = new ComparableItemStackCrucible(tempRecipe.input);
            tempMap.put(input, tempRecipe);
            if (!FluidRegistry.LAVA.equals(tempRecipe.getOutput().getFluid())) continue;
            tempSet.add(input);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        lavaSet.clear();
        lavaSet = tempSet;
    }

    public static CrucibleRecipe addRecipe(int energy, ItemStack input, FluidStack output) {
        if (input.func_190926_b() || output == null || output.amount <= 0 || energy <= 0 || CrucibleManager.recipeExists(input)) {
            return null;
        }
        ComparableItemStackCrucible inputCrucible = new ComparableItemStackCrucible(input);
        CrucibleRecipe recipe = new CrucibleRecipe(input, output, energy);
        recipeMap.put(inputCrucible, recipe);
        if (FluidRegistry.LAVA.equals(output.getFluid())) {
            lavaSet.add(inputCrucible);
        }
        return recipe;
    }

    public static CrucibleRecipe removeRecipe(ItemStack input) {
        ComparableItemStackCrucible inputCrucible = new ComparableItemStackCrucible(input);
        lavaSet.remove((Object)inputCrucible);
        return recipeMap.remove((Object)inputCrucible);
    }

    public static class ComparableItemStackCrucible
    extends ComparableItemStack {
        public static final String NUGGET = "nugget";
        public static final String INGOT = "ingot";
        public static final String ORE = "ore";
        public static final String BLOCK = "block";
        public static final String DUST = "dust";
        public static final String PLATE = "plate";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(INGOT) || oreName.startsWith(ORE) || oreName.startsWith(NUGGET) || oreName.startsWith(BLOCK) || oreName.startsWith(DUST) || oreName.equals(PLATE);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                for (Integer id : ids) {
                    if (id == -1 || !ComparableItemStackCrucible.safeOreType(ItemHelper.oreProxy.getOreName(id.intValue()))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackCrucible(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackCrucible.getOreID(stack);
        }

        public ComparableItemStackCrucible set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackCrucible.getOreID(stack);
            return this;
        }
    }

    public static class CrucibleRecipe {
        final ItemStack input;
        final FluidStack output;
        final int energy;

        CrucibleRecipe(ItemStack input, FluidStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public FluidStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

