/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalfoundation.block.BlockStorage;
import cofh.thermalfoundation.block.BlockStorageAlloy;
import cofh.thermalfoundation.item.ItemCoin;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CompactorManager {
    private static Map<ComparableItemStackCompactor, CompactorRecipe> recipeMapPress = new THashMap();
    private static Map<ComparableItemStackCompactor, CompactorRecipe> recipeMapStorage = new THashMap();
    private static Map<ComparableItemStackCompactor, CompactorRecipe> recipeMapMint = new THashMap();
    private static Set<ComparableItemStackCompactor> validationSet = new THashSet();
    public static final int DEFAULT_ENERGY = 4000;
    public static final int DEFAULT_ENERGY_STORAGE = 400;

    public static CompactorRecipe getRecipe(ItemStack input, Mode mode) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackCompactor query = new ComparableItemStackCompactor(input);
        CompactorRecipe recipe = null;
        switch (mode) {
            case PRESS: {
                recipe = recipeMapPress.get((Object)query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapPress.get((Object)query);
                break;
            }
            case STORAGE: {
                recipe = recipeMapStorage.get((Object)query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapStorage.get((Object)query);
                break;
            }
            case MINT: {
                recipe = recipeMapMint.get((Object)query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapMint.get((Object)query);
            }
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input, Mode mode) {
        return CompactorManager.getRecipe(input, mode) != null;
    }

    public static CompactorRecipe[] getRecipeList(Mode mode) {
        switch (mode) {
            case PRESS: {
                return recipeMapPress.values().toArray(new CompactorRecipe[recipeMapPress.size()]);
            }
            case STORAGE: {
                return recipeMapStorage.values().toArray(new CompactorRecipe[recipeMapStorage.size()]);
            }
        }
        return recipeMapMint.values().toArray(new CompactorRecipe[recipeMapMint.size()]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains((Object)new ComparableItemStackCompactor(input));
    }

    public static void initialize() {
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotIron, ItemMaterial.plateIron);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotGold, ItemMaterial.plateGold);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotCopper, ItemMaterial.plateCopper);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotTin, ItemMaterial.plateTin);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotSilver, ItemMaterial.plateSilver);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotLead, ItemMaterial.plateLead);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotAluminum, ItemMaterial.plateAluminum);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotNickel, ItemMaterial.plateNickel);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotPlatinum, ItemMaterial.platePlatinum);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotIridium, ItemMaterial.plateIridium);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotMithril, ItemMaterial.plateMithril);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotSteel, ItemMaterial.plateSteel);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotElectrum, ItemMaterial.plateElectrum);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotInvar, ItemMaterial.plateInvar);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotBronze, ItemMaterial.plateBronze);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotConstantan, ItemMaterial.plateConstantan);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotSignalum, ItemMaterial.plateSignalum);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotLumium, ItemMaterial.plateLumium);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotEnderium, ItemMaterial.plateEnderium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotIron, new ItemStack(Blocks.field_150339_S));
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotGold, new ItemStack(Blocks.field_150340_R));
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.gemDiamond, new ItemStack(Blocks.field_150484_ah));
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.gemEmerald, new ItemStack(Blocks.field_150475_bE));
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotCopper, BlockStorage.blockCopper);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotTin, BlockStorage.blockTin);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSilver, BlockStorage.blockSilver);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotLead, BlockStorage.blockLead);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotAluminum, BlockStorage.blockAluminum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotNickel, BlockStorage.blockNickel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotPlatinum, BlockStorage.blockPlatinum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotIridium, BlockStorage.blockIridium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotMithril, BlockStorage.blockMithril);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSteel, BlockStorageAlloy.blockSteel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotElectrum, BlockStorageAlloy.blockElectrum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotInvar, BlockStorageAlloy.blockInvar);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotBronze, BlockStorageAlloy.blockBronze);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotConstantan, BlockStorageAlloy.blockConstantan);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSignalum, BlockStorageAlloy.blockSignalum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotLumium, BlockStorageAlloy.blockLumium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotEnderium, BlockStorageAlloy.blockEnderium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetIron, ItemMaterial.ingotIron);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetGold, ItemMaterial.ingotGold);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetDiamond, ItemMaterial.gemDiamond);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetEmerald, ItemMaterial.gemEmerald);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetCopper, ItemMaterial.ingotCopper);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetTin, ItemMaterial.ingotTin);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSilver, ItemMaterial.ingotSilver);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetLead, ItemMaterial.ingotLead);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetAluminum, ItemMaterial.ingotAluminum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetNickel, ItemMaterial.ingotNickel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetPlatinum, ItemMaterial.ingotPlatinum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetIridium, ItemMaterial.ingotIridium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetMithril, ItemMaterial.ingotMithril);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSteel, ItemMaterial.ingotSteel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetElectrum, ItemMaterial.ingotElectrum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetInvar, ItemMaterial.ingotInvar);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetBronze, ItemMaterial.ingotBronze);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetConstantan, ItemMaterial.ingotConstantan);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSignalum, ItemMaterial.ingotSignalum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetLumium, ItemMaterial.ingotLumium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetEnderium, ItemMaterial.ingotEnderium);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetIron, ItemMaterial.ingotIron, new ItemStack(Blocks.field_150339_S), ItemCoin.coinIron);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetGold, ItemMaterial.ingotGold, new ItemStack(Blocks.field_150340_R), ItemCoin.coinGold);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetCopper, ItemMaterial.ingotCopper, BlockStorage.blockCopper, ItemCoin.coinCopper);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetTin, ItemMaterial.ingotTin, BlockStorage.blockTin, ItemCoin.coinTin);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetSilver, ItemMaterial.ingotSilver, BlockStorage.blockSilver, ItemCoin.coinSilver);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetLead, ItemMaterial.ingotLead, BlockStorage.blockLead, ItemCoin.coinLead);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetAluminum, ItemMaterial.ingotAluminum, BlockStorage.blockAluminum, ItemCoin.coinAluminum);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetNickel, ItemMaterial.ingotNickel, BlockStorage.blockNickel, ItemCoin.coinNickel);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetPlatinum, ItemMaterial.ingotPlatinum, BlockStorage.blockPlatinum, ItemCoin.coinPlatinum);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetIridium, ItemMaterial.ingotIridium, BlockStorage.blockIridium, ItemCoin.coinIridium);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetMithril, ItemMaterial.ingotMithril, BlockStorage.blockMithril, ItemCoin.coinMithril);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetSteel, ItemMaterial.ingotSteel, BlockStorageAlloy.blockSteel, ItemCoin.coinSteel);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetElectrum, ItemMaterial.ingotElectrum, BlockStorageAlloy.blockElectrum, ItemCoin.coinElectrum);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetInvar, ItemMaterial.ingotInvar, BlockStorageAlloy.blockInvar, ItemCoin.coinInvar);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetBronze, ItemMaterial.ingotBronze, BlockStorageAlloy.blockBronze, ItemCoin.coinBronze);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetConstantan, ItemMaterial.ingotConstantan, BlockStorageAlloy.blockConstantan, ItemCoin.coinConstantan);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetSignalum, ItemMaterial.ingotSignalum, BlockStorageAlloy.blockSignalum, ItemCoin.coinSignalum);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetLumium, ItemMaterial.ingotLumium, BlockStorageAlloy.blockLumium, ItemCoin.coinLumium);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetEnderium, ItemMaterial.ingotEnderium, BlockStorageAlloy.blockEnderium, ItemCoin.coinEnderium);
    }

    public static void loadRecipes() {
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapedOreRecipe) && !(recipe instanceof ShapelessOreRecipe)) continue;
        }
    }

    public static void refresh() {
        ComparableItemStackCompactor input;
        CompactorRecipe tempRecipe;
        THashMap tempPress = new THashMap(recipeMapPress.size());
        THashMap tempStorage = new THashMap(recipeMapStorage.size());
        THashMap tempMint = new THashMap(recipeMapMint.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<ComparableItemStackCompactor, CompactorRecipe> entry : recipeMapPress.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackCompactor(tempRecipe.input);
            tempPress.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackCompactor, CompactorRecipe> entry : recipeMapStorage.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackCompactor(tempRecipe.input);
            tempStorage.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackCompactor, CompactorRecipe> entry : recipeMapMint.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackCompactor(tempRecipe.input);
            tempMint.put(input, tempRecipe);
            tempSet.add(input);
        }
        recipeMapPress.clear();
        recipeMapStorage.clear();
        recipeMapMint.clear();
        recipeMapPress = tempPress;
        recipeMapStorage = tempStorage;
        recipeMapMint = tempMint;
        validationSet.clear();
        validationSet = tempSet;
    }

    public static CompactorRecipe addRecipe(int energy, ItemStack input, ItemStack output, Mode mode) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || CompactorManager.recipeExists(input, mode)) {
            return null;
        }
        CompactorRecipe recipe = new CompactorRecipe(input, output, energy);
        switch (mode) {
            case PRESS: {
                recipeMapPress.put(new ComparableItemStackCompactor(input), recipe);
                break;
            }
            case STORAGE: {
                recipeMapStorage.put(new ComparableItemStackCompactor(input), recipe);
                break;
            }
            case MINT: {
                recipeMapMint.put(new ComparableItemStackCompactor(input), recipe);
            }
        }
        validationSet.add(new ComparableItemStackCompactor(input));
        return recipe;
    }

    public static CompactorRecipe removeRecipe(ItemStack input, Mode mode) {
        switch (mode) {
            case PRESS: {
                return recipeMapPress.remove((Object)new ComparableItemStackCompactor(input));
            }
            case STORAGE: {
                return recipeMapStorage.remove((Object)new ComparableItemStackCompactor(input));
            }
        }
        return recipeMapMint.remove((Object)new ComparableItemStackCompactor(input));
    }

    private static void addDefaultPressRecipe(ItemStack input, ItemStack output) {
        CompactorManager.addRecipe(4000, input, output, Mode.PRESS);
    }

    private static void addDefaultStorageRecipe(ItemStack input, ItemStack output) {
        ItemStack inputStack = ItemHelper.cloneStack((ItemStack)input, (int)9);
        if (!CompactorManager.recipeExists(inputStack, Mode.STORAGE)) {
            CompactorManager.addRecipe(400, inputStack, output, Mode.STORAGE);
        }
    }

    private static void addDefaultStorageRecipe(ItemStack input, ItemStack output, int count) {
        ItemStack inputStack = ItemHelper.cloneStack((ItemStack)input, (int)count);
        if (!CompactorManager.recipeExists(inputStack, Mode.STORAGE)) {
            CompactorManager.addRecipe(400, inputStack, output, Mode.STORAGE);
        }
    }

    private static void addDefaultMintRecipe(ItemStack nugget, ItemStack ingot, ItemStack block, ItemStack output) {
        CompactorManager.addRecipe(2000, ItemHelper.cloneStack((ItemStack)nugget, (int)3), ItemHelper.cloneStack((ItemStack)output, (int)1), Mode.MINT);
        CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)ingot, (int)1), ItemHelper.cloneStack((ItemStack)output, (int)3), Mode.MINT);
        CompactorManager.addRecipe(24000, ItemHelper.cloneStack((ItemStack)block, (int)1), ItemHelper.cloneStack((ItemStack)output, (int)27), Mode.MINT);
    }

    public static class ComparableItemStackCompactor
    extends ComparableItemStack {
        public static final String NUGGET = "nugget";
        public static final String INGOT = "ingot";
        public static final String BLOCK = "block";
        public static final String DUST = "dust";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(NUGGET) || oreName.startsWith(INGOT) || oreName.startsWith(BLOCK) || oreName.startsWith(DUST);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                for (Integer id : ids) {
                    if (id == -1 || !ComparableItemStackCompactor.safeOreType(ItemHelper.oreProxy.getOreName(id.intValue()))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackCompactor(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackCompactor.getOreID(stack);
        }

        public ComparableItemStackCompactor set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackCompactor.getOreID(stack);
            return this;
        }
    }

    public static enum Mode {
        PRESS,
        STORAGE,
        MINT;

    }

    public static class CompactorRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        CompactorRecipe(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

