/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackSafe;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.item.ItemFertilizer;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ChargerManager {
    private static Map<ComparableItemStackSafe, ChargerRecipe> recipeMap = new THashMap();
    public static final int DEFAULT_ENERGY = 8000;

    public static ChargerRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackSafe query = new ComparableItemStackSafe(input);
        ChargerRecipe recipe = recipeMap.get(query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return ChargerManager.getRecipe(input) != null;
    }

    public static ChargerRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new ChargerRecipe[recipeMap.size()]);
    }

    public static void initialize() {
        ChargerManager.addRecipe(8000, ItemFertilizer.fertilizerRich, ItemFertilizer.fertilizerFlux);
        ChargerManager.loadRecipes();
    }

    public static void loadRecipes() {
        if (ItemHelper.oreNameExists((String)"crystalCertusQuartz") && ItemHelper.oreNameExists((String)"crystalCertusQuartzCharged")) {
            ChargerManager.addRecipe(8000, (ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz", (boolean)false).get(0), (ItemStack)OreDictionary.getOres((String)"crystalCertusQuartzCharged", (boolean)false).get(0));
        }
        if (ItemHelper.oreNameExists((String)"oreCertusQuartz") && ItemHelper.oreNameExists((String)"oreCertusQuartzCharged")) {
            ChargerManager.addRecipe(8000, (ItemStack)OreDictionary.getOres((String)"oreCertusQuartz", (boolean)false).get(0), (ItemStack)OreDictionary.getOres((String)"oreCertusQuartzCharged", (boolean)false).get(0));
        }
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackSafe, ChargerRecipe> entry : recipeMap.entrySet()) {
            ChargerRecipe tempRecipe = entry.getValue();
            tempMap.put(new ComparableItemStackSafe(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static ChargerRecipe addRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || ChargerManager.recipeExists(input)) {
            return null;
        }
        ChargerRecipe recipe = new ChargerRecipe(input, output, energy);
        recipeMap.put(new ComparableItemStackSafe(input), recipe);
        return recipe;
    }

    public static ChargerRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove(new ComparableItemStackSafe(input));
    }

    private static void addOreDictRecipe(String oreName, ItemStack output) {
        ChargerManager.addOreDictRecipe(8000, oreName, output);
    }

    private static void addOreDictRecipe(int energy, String oreName, ItemStack output) {
        if (ItemHelper.oreNameExists((String)oreName) && !ChargerManager.recipeExists((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0))) {
            ChargerManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0)), (int)1), output);
        }
    }

    public static class ChargerRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        public ChargerRecipe(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

