/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import com.google.common.collect.ImmutableSet;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CompressionManager {
    private static TObjectIntHashMap<String> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 100000;

    public static Set<String> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static boolean isValidFuel(FluidStack fluid) {
        return fluid != null && fuelMap.containsKey((Object)fluid.getFluid().getName());
    }

    public static int getFuelEnergy(FluidStack fluid) {
        return fluid == null ? 0 : fuelMap.get((Object)fluid.getFluid().getName());
    }

    public static int getFuelEnergy100mB(FluidStack fluid) {
        return fluid == null ? 0 : fuelMap.get((Object)fluid.getFluid().getName()) / 10;
    }

    public static void initialize() {
        CompressionManager.addFuel("creosote", 100000);
        CompressionManager.addFuel("coal", 400000);
        CompressionManager.addFuel("crude_oil", 400000);
        CompressionManager.addFuel("tree_oil", 1000000);
        CompressionManager.addFuel("refined_oil", 1250000);
        CompressionManager.addFuel("refined_fuel", 2000000);
        CompressionManager.loadFuels();
    }

    public static void loadFuels() {
        CompressionManager.addFuel("canolaoil", 80000);
        CompressionManager.addFuel("refinedcanolaoil", 200000);
        CompressionManager.addFuel("crystaloil", 400000);
        CompressionManager.addFuel("empoweredoil", 700000);
        CompressionManager.addFuel("bio.ethanol", 500000);
        CompressionManager.addFuel("biodiesel", 500000);
        CompressionManager.addFuel("biofuel", 500000);
    }

    public static void refresh() {
    }

    public static boolean addFuel(String fluidName, int energy) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName) || energy < 10000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)fluidName, energy);
        return true;
    }

    public static boolean removeFuel(String fluidName) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName)) {
            return false;
        }
        fuelMap.remove((Object)fluidName);
        return true;
    }
}

