/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakery.generation.IItemBakery;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.render.RenderCell;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class RenderFrame
implements IItemBakery {
    public static final RenderFrame INSTANCE = new RenderFrame();

    public List<BakedQuad> bakeItemQuads(EnumFacing dir, ItemStack stack) {
        if (dir == null) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                int i = face.ordinal();
                RenderCell.modelFrame.render(ccrs, i * 4, i * 4 + 4, new IVertexOperation[]{new IconTransformation(this.getFrameTexture(face, stack))});
                TextureAtlasSprite inner = this.getInnerTexture(face, stack);
                if (inner == null) continue;
                RenderCell.modelFrame.render(ccrs, i * 4 + 24, i * 4 + 28, new IVertexOperation[]{new IconTransformation(inner)});
            }
            buffer.func_178977_d();
            return buffer.bake();
        }
        return ImmutableList.of();
    }

    public ModelProperties.PerspectiveProperties getModelProperties(ItemStack stack) {
        return ModelProperties.PerspectiveProperties.DEFAULT_BLOCK;
    }

    private TextureAtlasSprite getFrameTexture(EnumFacing face, ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                if (face == EnumFacing.UP) {
                    return TETextures.MACHINE_FRAME_TOP;
                }
                if (face == EnumFacing.DOWN) {
                    return TETextures.MACHINE_FRAME_BOTTOM;
                }
                return TETextures.MACHINE_FRAME_SIDE;
            }
            case 64: {
                if (face == EnumFacing.UP) {
                    return TETextures.DEVICE_FRAME_TOP;
                }
                if (face == EnumFacing.DOWN) {
                    return TETextures.DEVICE_FRAME_BOTTOM;
                }
                return TETextures.DEVICE_FRAME_SIDE;
            }
            case 128: {
                return TETextures.CELL_SIDE_0;
            }
            case 160: {
                return TETextures.ILLUMINATOR_FRAME;
            }
        }
        return TextureUtils.getMissingSprite();
    }

    private TextureAtlasSprite getInnerTexture(EnumFacing face, ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return TETextures.MACHINE_FRAME_INNER;
            }
            case 64: {
                return TETextures.DEVICE_FRAME_INNER;
            }
            case 128: {
                return TETextures.CELL_INNER_0;
            }
        }
        return null;
    }

    private TextureAtlasSprite getCenterTexture(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return TextureUtils.getBlockTexture((String)"thermalfoundation:storage/block_tin");
            }
            case 64: {
                return TextureUtils.getBlockTexture((String)"thermalfoundation:storage/block_copper");
            }
            case 128: {
                return TextureUtils.getBlockTexture((String)"thermalfoundation:storage/block_lead");
            }
        }
        return null;
    }
}

