/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.enchanter;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.machine.TileEnchanter;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class EnchanterRecipeWrapper
extends BaseRecipeWrapper {
    final List<List<ItemStack>> inputs;
    final List<List<FluidStack>> inputFluids;
    final List<ItemStack> outputs;
    final EnchanterManager.Type type;
    final IDrawableAnimated fluid;
    final IDrawableAnimated progress;
    final IDrawableAnimated speed;

    public EnchanterRecipeWrapper(IGuiHelper guiHelper, EnchanterManager.EnchanterRecipe recipe) {
        this(guiHelper, recipe, "thermalexpansion.enchanter");
    }

    public EnchanterRecipeWrapper(IGuiHelper guiHelper, EnchanterManager.EnchanterRecipe recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<List<ItemStack>> recipeInputs = new ArrayList<List<ItemStack>>();
        ArrayList<FluidStack> recipeInputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> recipeInputsPrimary = new ArrayList<ItemStack>();
        ArrayList<ItemStack> recipeInputsSecondary = new ArrayList<ItemStack>();
        int oreID = EnchanterManager.ComparableItemStackEnchanter.getOreID(recipe.getPrimaryInput());
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputsPrimary.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getPrimaryInput().func_190916_E()));
            }
        } else {
            recipeInputsPrimary.add(recipe.getPrimaryInput());
        }
        oreID = EnchanterManager.ComparableItemStackEnchanter.getOreID(recipe.getSecondaryInput());
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputsSecondary.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getSecondaryInput().func_190916_E()));
            }
        } else {
            recipeInputsSecondary.add(recipe.getSecondaryInput());
        }
        recipeInputs.add(recipeInputsPrimary);
        recipeInputs.add(recipeInputsSecondary);
        recipeInputFluids.add(new FluidStack(FluidRegistry.WATER, recipe.getExperience()));
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        recipeOutputs.add(recipe.getOutput());
        this.inputs = recipeInputs;
        this.inputFluids = Collections.singletonList(recipeInputFluids);
        this.outputs = recipeOutputs;
        this.energy = recipe.getEnergy();
        this.type = recipe.getType();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(1);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(1);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(9);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileEnchanter.basePower, IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileEnchanter.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setInputLists(FluidStack.class, this.inputFluids);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        JEIPluginTE.drawFluid(69, 23, this.inputFluids.get(0).get(0), 24, 16);
        this.fluid.draw(minecraft, 69, 23);
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 34);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

