/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class TopPlugin {
    public static final String MOD_ID = "theoneprobe";
    public static final String MOD_NAME = "The One Probe";

    private TopPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for The One Probe is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            FMLInterModComms.sendFunctionMessage((String)MOD_ID, (String)"getTheOneProbe", (String)"cofh.thermalexpansion.plugins.TopPlugin$InfoProvider");
            ThermalExpansion.LOG.info("Thermal Expansion: The One Probe Plugin Enabled.");
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: The One Probe Plugin encountered an error:", t);
        }
    }

    public static class InfoProvider
    implements IProbeInfoProvider,
    Function<ITheOneProbe, Void> {
        @Override
        public Void apply(@Nullable ITheOneProbe probe) {
            if (probe != null) {
                probe.registerProvider((IProbeInfoProvider)this);
            }
            return null;
        }

        public String getID() {
            return "thermalexpansion.probeplugin";
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, EntityPlayer entityPlayer, World world, IBlockState iBlockState, IProbeHitData iProbeHitData) {
            TileEntity te = world.func_175625_s(iProbeHitData.getPos());
            if (te instanceof TileTEBase) {
                TileTEBase tile = (TileTEBase)te;
                tile.provideInfo(iProbeInfo, iProbeHitData.getSideHit(), entityPlayer);
            }
        }
    }
}

