/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.TapperManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TemplatePlugin {
    public static final String MOD_ID = "template";
    public static final String MOD_NAME = "Template";

    private TemplatePlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Template is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            ThermalExpansion.LOG.info("Thermal Expansion: Template Plugin Enabled.");
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Template Plugin encountered an error:", t);
        }
    }

    private static ItemStack getBlockStack(String name, int amount, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("template:" + name));
        return block != null ? new ItemStack(block, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getBlockStack(String name, int amount) {
        return TemplatePlugin.getBlockStack(name, amount, 0);
    }

    private static Block getBlock(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("template:" + name));
    }

    private static ItemStack getItem(String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("template:" + name));
        return item != null ? new ItemStack(item, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getItem(String name) {
        return TemplatePlugin.getItem(name, 1, 0);
    }

    private static void addLeafMapping(Block logBlock, Block leafBlock, int metadata) {
        IBlockState logState = logBlock.func_176203_a(metadata);
        for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
            IBlockState leafState = leafBlock.func_176203_a(metadata).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
            TapperManager.addLeafMappingDirect(logState, leafState);
        }
    }
}

