/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.TapperManager;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RusticPlugin {
    public static final String MOD_ID = "rustic";
    public static final String MOD_NAME = "Rustic";

    private RusticPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Rustic is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            ItemStack beeswax = RusticPlugin.getItem("beeswax");
            ItemStack chiliPepper = RusticPlugin.getItem("chili_pepper");
            ItemStack honeycomb = RusticPlugin.getItem("honeycomb");
            ItemStack grapes = RusticPlugin.getItem("grapes");
            ItemStack ironberries = RusticPlugin.getItem("ironberries");
            ItemStack olives = RusticPlugin.getItem("olives");
            ItemStack tomato = RusticPlugin.getItem("tomato");
            ItemStack wildberries = RusticPlugin.getItem("wildberries");
            ItemStack seedApple = RusticPlugin.getItem("apple_seeds");
            ItemStack seedChiliPepper = RusticPlugin.getItem("chili_pepper_seeds");
            ItemStack seedGrape = RusticPlugin.getItem("grape_stem");
            ItemStack seedTomato = RusticPlugin.getItem("tomato_seeds");
            ItemStack aloeVera = RusticPlugin.getItem("aloe_vera");
            ItemStack bloodOrchid = RusticPlugin.getItem("blood_orchid");
            ItemStack chamomile = RusticPlugin.getItem("chamomile");
            ItemStack cloudsbluff = RusticPlugin.getItem("cloudsbluff");
            ItemStack cohosh = RusticPlugin.getItem("cohosh");
            ItemStack coreRoot = RusticPlugin.getItem("core_root");
            ItemStack deathstalkMushroom = RusticPlugin.getItem("deathstalk_mushroom");
            ItemStack ginseng = RusticPlugin.getItem("ginseng");
            ItemStack horsetail = RusticPlugin.getItem("horsetail");
            ItemStack marshMallow = RusticPlugin.getItem("marsh_mallow");
            ItemStack mooncapMushroom = RusticPlugin.getItem("mooncap_mushroom");
            ItemStack windThistle = RusticPlugin.getItem("wind_thistle");
            ItemStack logOlive = RusticPlugin.getBlockStack("log", 1, 0);
            ItemStack logIronwood = RusticPlugin.getBlockStack("log", 1, 1);
            ItemStack saplingOlive = RusticPlugin.getItem("sapling", 1, 0);
            ItemStack saplingIronwood = RusticPlugin.getItem("sapling", 1, 1);
            ItemStack saplingApple = RusticPlugin.getItem("sapling_apple", 1, 0);
            Block log = RusticPlugin.getBlock("log");
            Block leaves = RusticPlugin.getBlock("leaves");
            Block leavesApple = RusticPlugin.getBlock("leaves_apple");
            Fluid honey = FluidRegistry.getFluid((String)"honey");
            Fluid grapejuice = FluidRegistry.getFluid((String)"grapejuice");
            Fluid ironberryjuice = FluidRegistry.getFluid((String)"ironberryjuice");
            Fluid oliveoil = FluidRegistry.getFluid((String)"oliveoil");
            Fluid wildberryjuice = FluidRegistry.getFluid((String)"wildberryjuice");
            Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
            InsolatorManager.addDefaultRecipe(seedChiliPepper, ItemHelper.cloneStack((ItemStack)chiliPepper, (int)2), seedChiliPepper, 100);
            InsolatorManager.addDefaultRecipe(seedGrape, ItemHelper.cloneStack((ItemStack)grapes, (int)2), seedGrape, 100);
            InsolatorManager.addDefaultRecipe(seedTomato, ItemHelper.cloneStack((ItemStack)tomato, (int)2), seedTomato, 100);
            InsolatorManager.addDefaultRecipe(aloeVera, ItemHelper.cloneStack((ItemStack)aloeVera, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(bloodOrchid, ItemHelper.cloneStack((ItemStack)bloodOrchid, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(chamomile, ItemHelper.cloneStack((ItemStack)chamomile, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(cloudsbluff, ItemHelper.cloneStack((ItemStack)cloudsbluff, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(cohosh, ItemHelper.cloneStack((ItemStack)cohosh, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(coreRoot, ItemHelper.cloneStack((ItemStack)coreRoot, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(ginseng, ItemHelper.cloneStack((ItemStack)ginseng, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(horsetail, ItemHelper.cloneStack((ItemStack)horsetail, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(marshMallow, ItemHelper.cloneStack((ItemStack)marshMallow, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(windThistle, ItemHelper.cloneStack((ItemStack)windThistle, (int)3), ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(deathstalkMushroom, ItemHelper.cloneStack((ItemStack)deathstalkMushroom, (int)2), ItemStack.field_190927_a, 0, false, InsolatorManager.Type.MYCELIUM);
            InsolatorManager.addDefaultRecipe(mooncapMushroom, ItemHelper.cloneStack((ItemStack)mooncapMushroom, (int)2), ItemStack.field_190927_a, 0, false, InsolatorManager.Type.MYCELIUM);
            InsolatorManager.addDefaultTreeRecipe(saplingOlive, ItemHelper.cloneStack((ItemStack)logOlive, (int)4), saplingOlive, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingIronwood, ItemHelper.cloneStack((ItemStack)logIronwood, (int)4), saplingIronwood, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingApple, new ItemStack(Blocks.field_150364_r, 4, 0), saplingApple, 50, false, InsolatorManager.Type.TREE);
            int energy = 2400;
            if (grapejuice != null) {
                TransposerManager.addExtractRecipe(energy, grapes, ItemStack.field_190927_a, new FluidStack(grapejuice, 250), 0, false);
            }
            if (ironberryjuice != null) {
                TransposerManager.addExtractRecipe(energy, ironberries, ItemStack.field_190927_a, new FluidStack(ironberryjuice, 250), 0, false);
            }
            if (oliveoil != null) {
                TransposerManager.addExtractRecipe(energy, olives, ItemStack.field_190927_a, new FluidStack(oliveoil, 250), 0, false);
            }
            if (wildberryjuice != null) {
                TransposerManager.addExtractRecipe(energy, wildberries, ItemStack.field_190927_a, new FluidStack(wildberryjuice, 250), 0, false);
            }
            if (seed_oil != null) {
                TransposerManager.addExtractRecipe(energy, seedApple, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, seedChiliPepper, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, seedGrape, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, seedTomato, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
            }
            if (honey != null) {
                CentrifugeManager.addRecipe(4000, honeycomb, Arrays.asList(beeswax), Arrays.asList(100), new FluidStack(honey, 250));
            }
            TapperManager.addMapping(logOlive, new FluidStack(TFFluids.fluidResin, 50));
            TapperManager.addMapping(logIronwood, new FluidStack(TFFluids.fluidResin, 50));
            RusticPlugin.addLeafMapping(log, leaves, 0);
            RusticPlugin.addLeafMapping(log, leaves, 1);
            RusticPlugin.addLeafMapping(Blocks.field_150364_r, leavesApple, 0);
            ThermalExpansion.LOG.info("Thermal Expansion: Rustic Plugin Enabled.");
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Rustic Plugin encountered an error:", t);
        }
    }

    private static ItemStack getBlockStack(String name, int amount, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rustic:" + name));
        return block != null ? new ItemStack(block, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getBlockStack(String name, int amount) {
        return RusticPlugin.getBlockStack(name, amount, 0);
    }

    private static Block getBlock(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("rustic:" + name));
    }

    private static ItemStack getItem(String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rustic:" + name));
        return item != null ? new ItemStack(item, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getItem(String name) {
        return RusticPlugin.getItem(name, 1, 0);
    }

    private static void addLeafMapping(Block logBlock, Block leafBlock, int metadata) {
        IBlockState logState = logBlock.func_176203_a(metadata);
        for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
            IBlockState leafState = leafBlock.func_176203_a(metadata).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
            TapperManager.addLeafMappingDirect(logState, leafState);
        }
    }
}

