/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class QuarkPlugin {
    public static final String MOD_ID = "quark";
    public static final String MOD_NAME = "Quark";

    private QuarkPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Quark is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            ItemStack chestSpruce = QuarkPlugin.getBlockStack("custom_chest", 1, 0);
            ItemStack chestBirch = QuarkPlugin.getBlockStack("custom_chest", 1, 1);
            ItemStack chestJungle = QuarkPlugin.getBlockStack("custom_chest", 1, 2);
            ItemStack chestAcacia = QuarkPlugin.getBlockStack("custom_chest", 1, 3);
            ItemStack chestDarkOak = QuarkPlugin.getBlockStack("custom_chest", 1, 4);
            ItemStack chestTrappedSpruce = QuarkPlugin.getBlockStack("custom_chest_trap", 1, 0);
            ItemStack chestTrappedBirch = QuarkPlugin.getBlockStack("custom_chest_trap", 1, 1);
            ItemStack chestTrappedJungle = QuarkPlugin.getBlockStack("custom_chest_trap", 1, 2);
            ItemStack chestTrappedAcacia = QuarkPlugin.getBlockStack("custom_chest_trap", 1, 3);
            ItemStack chestTrappedDarkOak = QuarkPlugin.getBlockStack("custom_chest_trap", 1, 4);
            ItemStack bookshelfSpruce = QuarkPlugin.getBlockStack("custom_bookshelf", 1, 0);
            ItemStack bookshelfBirch = QuarkPlugin.getBlockStack("custom_bookshelf", 1, 1);
            ItemStack bookshelfJungle = QuarkPlugin.getBlockStack("custom_bookshelf", 1, 2);
            ItemStack bookshelfAcacia = QuarkPlugin.getBlockStack("custom_bookshelf", 1, 3);
            ItemStack bookshelfDarkOak = QuarkPlugin.getBlockStack("custom_bookshelf", 1, 4);
            ItemStack trapdoorSpruce = QuarkPlugin.getBlockStack("spruce_trapdoor", 1);
            ItemStack trapdoorBirch = QuarkPlugin.getBlockStack("birch_trapdoor", 1);
            ItemStack trapdoorJungle = QuarkPlugin.getBlockStack("jungle_trapdoor", 1);
            ItemStack trapdoorAcacia = QuarkPlugin.getBlockStack("acacia_trapdoor", 1);
            ItemStack trapdoorDarkOak = QuarkPlugin.getBlockStack("dark_oak_trapdoor", 1);
            int energy = 3000;
            energy = 2400;
            SawmillManager.addRecipe(energy, chestSpruce, new ItemStack(Blocks.field_150344_f, 4, 1), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestBirch, new ItemStack(Blocks.field_150344_f, 4, 2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestJungle, new ItemStack(Blocks.field_150344_f, 4, 3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestAcacia, new ItemStack(Blocks.field_150344_f, 4, 4), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestDarkOak, new ItemStack(Blocks.field_150344_f, 4, 5), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestTrappedSpruce, new ItemStack(Blocks.field_150344_f, 4, 1), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestTrappedBirch, new ItemStack(Blocks.field_150344_f, 4, 2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestTrappedJungle, new ItemStack(Blocks.field_150344_f, 4, 3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestTrappedAcacia, new ItemStack(Blocks.field_150344_f, 4, 4), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, chestTrappedDarkOak, new ItemStack(Blocks.field_150344_f, 4, 5), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustWood, (int)2));
            SawmillManager.addRecipe(energy, bookshelfSpruce, new ItemStack(Blocks.field_150344_f, 3, 1), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, bookshelfBirch, new ItemStack(Blocks.field_150344_f, 3, 2), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, bookshelfJungle, new ItemStack(Blocks.field_150344_f, 3, 3), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, bookshelfAcacia, new ItemStack(Blocks.field_150344_f, 3, 4), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, bookshelfDarkOak, new ItemStack(Blocks.field_150344_f, 3, 5), new ItemStack(Items.field_151122_aG, 3), 25);
            SawmillManager.addRecipe(energy, trapdoorSpruce, new ItemStack(Blocks.field_150344_f, 1, 1), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, trapdoorBirch, new ItemStack(Blocks.field_150344_f, 1, 2), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, trapdoorJungle, new ItemStack(Blocks.field_150344_f, 1, 3), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, trapdoorAcacia, new ItemStack(Blocks.field_150344_f, 1, 4), ItemMaterial.dustWood, 75);
            SawmillManager.addRecipe(energy, trapdoorDarkOak, new ItemStack(Blocks.field_150344_f, 1, 5), ItemMaterial.dustWood, 75);
            ThermalExpansion.LOG.info("Thermal Expansion: Quark Plugin Enabled.");
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Quark Plugin encountered an error:", t);
        }
    }

    private static ItemStack getBlockStack(String name, int amount, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:" + name));
        return block != null ? new ItemStack(block, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getBlockStack(String name, int amount) {
        return QuarkPlugin.getBlockStack(name, amount, 0);
    }

    private static Block getBlock(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:" + name));
    }

    private static ItemStack getItem(String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("quark:" + name));
        return item != null ? new ItemStack(item, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getItem(String name) {
        return QuarkPlugin.getItem(name, 1, 0);
    }
}

