/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.TapperManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import cofh.thermalfoundation.init.TFFluids;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class NaturaPlugin {
    public static final String MOD_ID = "natura";
    public static final String MOD_NAME = "Natura";

    private NaturaPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Natura is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            ItemStack seedBarley = NaturaPlugin.getItem("overworld_seeds", 1, 0);
            ItemStack seedCotton = NaturaPlugin.getItem("overworld_seeds", 1, 1);
            ItemStack raspberry = NaturaPlugin.getItem("edibles", 1, 2);
            ItemStack blueberry = NaturaPlugin.getItem("edibles", 1, 3);
            ItemStack blackberry = NaturaPlugin.getItem("edibles", 1, 4);
            ItemStack maloberry = NaturaPlugin.getItem("edibles", 1, 5);
            ItemStack blightberry = NaturaPlugin.getItem("edibles", 1, 6);
            ItemStack duskberry = NaturaPlugin.getItem("edibles", 1, 7);
            ItemStack skyberry = NaturaPlugin.getItem("edibles", 1, 8);
            ItemStack stingberry = NaturaPlugin.getItem("edibles", 1, 9);
            ItemStack bushRaspberry = NaturaPlugin.getBlockStack("overworld_berrybush_raspberry", 1, 0);
            ItemStack bushBlueberry = NaturaPlugin.getBlockStack("overworld_berrybush_raspberry", 1, 0);
            ItemStack bushBlackberry = NaturaPlugin.getBlockStack("overworld_berrybush_raspberry", 1, 0);
            ItemStack bushMaloberry = NaturaPlugin.getBlockStack("overworld_berrybush_raspberry", 1, 0);
            ItemStack bushBlightberry = NaturaPlugin.getBlockStack("nether_berrybush_blightberry", 1, 0);
            ItemStack bushDuskberry = NaturaPlugin.getBlockStack("nether_berrybush_duskberry", 1, 0);
            ItemStack bushSkyberry = NaturaPlugin.getBlockStack("nether_berrybush_skyberry", 1, 0);
            ItemStack bushStingberry = NaturaPlugin.getBlockStack("nether_berrybush_stingberry", 1, 0);
            ItemStack saguaroFruit = NaturaPlugin.getItem("saguaro_fruit_item");
            ItemStack saguaroCactus = NaturaPlugin.getBlockStack("saguaro", 1, 0);
            ItemStack saguaroCactusBaby = NaturaPlugin.getBlockStack("saguaro_baby", 1, 0);
            ItemStack glowshroomGreen = NaturaPlugin.getBlockStack("nether_glowshroom", 1, 0);
            ItemStack glowshroomBlue = NaturaPlugin.getBlockStack("nether_glowshroom", 1, 1);
            ItemStack glowshroomPurple = NaturaPlugin.getBlockStack("nether_glowshroom", 1, 2);
            ItemStack logMaple = NaturaPlugin.getBlockStack("overworld_logs", 1, 0);
            ItemStack logSilverbell = NaturaPlugin.getBlockStack("overworld_logs", 1, 1);
            ItemStack logAmaranth = NaturaPlugin.getBlockStack("overworld_logs", 1, 2);
            ItemStack logTigerwood = NaturaPlugin.getBlockStack("overworld_logs", 1, 3);
            ItemStack logWillow = NaturaPlugin.getBlockStack("overworld_logs2", 1, 0);
            ItemStack logEucalyptus = NaturaPlugin.getBlockStack("overworld_logs2", 1, 1);
            ItemStack logHopseed = NaturaPlugin.getBlockStack("overworld_logs2", 1, 2);
            ItemStack logSakura = NaturaPlugin.getBlockStack("overworld_logs2", 1, 3);
            ItemStack saplingMaple = NaturaPlugin.getItem("overworld_sapling", 1, 0);
            ItemStack saplingSilverbell = NaturaPlugin.getItem("overworld_sapling", 1, 1);
            ItemStack saplingAmaranth = NaturaPlugin.getItem("overworld_sapling", 1, 2);
            ItemStack saplingTigerwood = NaturaPlugin.getItem("overworld_sapling", 1, 3);
            ItemStack saplingWillow = NaturaPlugin.getItem("overworld_sapling2", 1, 0);
            ItemStack saplingEucalyptus = NaturaPlugin.getItem("overworld_sapling2", 1, 1);
            ItemStack saplingHopseed = NaturaPlugin.getItem("overworld_sapling2", 1, 2);
            ItemStack saplingSakura = NaturaPlugin.getItem("overworld_sapling2", 1, 3);
            ItemStack saplingGhostwood = NaturaPlugin.getItem("nether_sapling", 1, 0);
            ItemStack saplingFusewood = NaturaPlugin.getItem("nether_sapling", 1, 1);
            ItemStack saplingDarkwood = NaturaPlugin.getItem("nether_sapling", 1, 2);
            ItemStack saplingBloodwood = NaturaPlugin.getItem("nether_sapling2", 1, 0);
            ItemStack logGhostwood = NaturaPlugin.getBlockStack("nether_logs", 1, 0);
            ItemStack logDarkwood = NaturaPlugin.getBlockStack("nether_logs", 1, 1);
            ItemStack logFusewood = NaturaPlugin.getBlockStack("nether_logs", 1, 2);
            ItemStack logBloodwood = NaturaPlugin.getBlockStack("nether_logs2", 1, 0);
            Block log = NaturaPlugin.getBlock("overworld_logs");
            Block log2 = NaturaPlugin.getBlock("overworld_logs2");
            Block leaves = NaturaPlugin.getBlock("overworld_leaves");
            Block leaves2 = NaturaPlugin.getBlock("overworld_leaves2");
            Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
            InsolatorManager.addDefaultRecipe(bushRaspberry, ItemHelper.cloneStack((ItemStack)raspberry, (int)2), bushRaspberry, 100);
            InsolatorManager.addDefaultRecipe(bushBlueberry, ItemHelper.cloneStack((ItemStack)blueberry, (int)2), bushBlueberry, 100);
            InsolatorManager.addDefaultRecipe(bushBlackberry, ItemHelper.cloneStack((ItemStack)blackberry, (int)2), bushBlackberry, 100);
            InsolatorManager.addDefaultRecipe(bushMaloberry, ItemHelper.cloneStack((ItemStack)maloberry, (int)2), bushMaloberry, 100);
            InsolatorManager.addDefaultRecipe(bushBlightberry, ItemHelper.cloneStack((ItemStack)blightberry, (int)2), bushBlightberry, 100, false, InsolatorManager.Type.NETHER);
            InsolatorManager.addDefaultRecipe(bushDuskberry, ItemHelper.cloneStack((ItemStack)duskberry, (int)2), bushDuskberry, 100, false, InsolatorManager.Type.NETHER);
            InsolatorManager.addDefaultRecipe(bushSkyberry, ItemHelper.cloneStack((ItemStack)skyberry, (int)2), bushSkyberry, 100, false, InsolatorManager.Type.NETHER);
            InsolatorManager.addDefaultRecipe(bushStingberry, ItemHelper.cloneStack((ItemStack)stingberry, (int)2), bushStingberry, 100, false, InsolatorManager.Type.NETHER);
            InsolatorManager.addDefaultRecipe(saguaroFruit, saguaroCactusBaby, ItemStack.field_190927_a, 0);
            InsolatorManager.addDefaultRecipe(saguaroCactusBaby, ItemHelper.cloneStack((ItemStack)saguaroFruit, (int)2), saguaroCactus, 0);
            InsolatorManager.addDefaultRecipe(glowshroomGreen, ItemHelper.cloneStack((ItemStack)glowshroomGreen, (int)2), ItemStack.field_190927_a, 0, false, InsolatorManager.Type.NETHER);
            InsolatorManager.addDefaultRecipe(glowshroomBlue, ItemHelper.cloneStack((ItemStack)glowshroomBlue, (int)2), ItemStack.field_190927_a, 0, false, InsolatorManager.Type.NETHER);
            InsolatorManager.addDefaultRecipe(glowshroomPurple, ItemHelper.cloneStack((ItemStack)glowshroomPurple, (int)2), ItemStack.field_190927_a, 0, false, InsolatorManager.Type.NETHER);
            InsolatorManager.addDefaultTreeRecipe(saplingMaple, ItemHelper.cloneStack((ItemStack)logMaple, (int)4), saplingMaple, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingSilverbell, ItemHelper.cloneStack((ItemStack)logSilverbell, (int)4), saplingSilverbell, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingAmaranth, ItemHelper.cloneStack((ItemStack)logAmaranth, (int)4), saplingAmaranth, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingTigerwood, ItemHelper.cloneStack((ItemStack)logTigerwood, (int)4), saplingTigerwood, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingWillow, ItemHelper.cloneStack((ItemStack)logWillow, (int)4), saplingWillow, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingEucalyptus, ItemHelper.cloneStack((ItemStack)logEucalyptus, (int)4), saplingEucalyptus, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingHopseed, ItemHelper.cloneStack((ItemStack)logHopseed, (int)4), saplingHopseed, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingSakura, ItemHelper.cloneStack((ItemStack)logSakura, (int)4), saplingSakura, 50, false, InsolatorManager.Type.TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingGhostwood, ItemHelper.cloneStack((ItemStack)logGhostwood, (int)4), saplingGhostwood, 50, false, InsolatorManager.Type.NETHER_TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingFusewood, ItemHelper.cloneStack((ItemStack)logDarkwood, (int)4), saplingFusewood, 50, false, InsolatorManager.Type.NETHER_TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingDarkwood, ItemHelper.cloneStack((ItemStack)logFusewood, (int)4), saplingDarkwood, 50, false, InsolatorManager.Type.NETHER_TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingBloodwood, ItemHelper.cloneStack((ItemStack)logBloodwood, (int)4), saplingBloodwood, 50, false, InsolatorManager.Type.NETHER_TREE);
            if (seed_oil != null) {
                TransposerManager.addExtractRecipe(2400, seedBarley, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(2400, seedCotton, ItemStack.field_190927_a, new FluidStack(seed_oil, 10), 0, false);
            }
            TapperManager.addMapping(logMaple, new FluidStack(TFFluids.fluidSap, 100));
            TapperManager.addMapping(logSilverbell, new FluidStack(TFFluids.fluidResin, 50));
            TapperManager.addMapping(logAmaranth, new FluidStack(TFFluids.fluidResin, 50));
            TapperManager.addMapping(logTigerwood, new FluidStack(TFFluids.fluidResin, 50));
            TapperManager.addMapping(logWillow, new FluidStack(TFFluids.fluidResin, 50));
            TapperManager.addMapping(logEucalyptus, new FluidStack(TFFluids.fluidResin, 50));
            TapperManager.addMapping(logHopseed, new FluidStack(TFFluids.fluidResin, 50));
            TapperManager.addMapping(logSakura, new FluidStack(TFFluids.fluidSap, 50));
            NaturaPlugin.addLeafMapping(log, leaves, 0);
            NaturaPlugin.addLeafMapping(log, leaves, 1);
            NaturaPlugin.addLeafMapping(log, leaves, 2);
            NaturaPlugin.addLeafMapping(log, leaves, 3);
            NaturaPlugin.addLeafMapping(log2, leaves2, 0);
            NaturaPlugin.addLeafMapping(log2, leaves2, 1);
            NaturaPlugin.addLeafMapping(log2, leaves2, 2);
            NaturaPlugin.addLeafMapping(log2, leaves2, 3);
            ThermalExpansion.LOG.info("Thermal Expansion: Natura Plugin Enabled.");
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Natura Plugin encountered an error:", t);
        }
    }

    private static ItemStack getBlockStack(String name, int amount, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("natura:" + name));
        return block != null ? new ItemStack(block, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getBlockStack(String name, int amount) {
        return NaturaPlugin.getBlockStack(name, amount, 0);
    }

    private static Block getBlock(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("natura:" + name));
    }

    private static ItemStack getItem(String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("natura:" + name));
        return item != null ? new ItemStack(item, amount, meta) : ItemStack.field_190927_a;
    }

    private static ItemStack getItem(String name) {
        return NaturaPlugin.getItem(name, 1, 0);
    }

    private static void addLeafMapping(Block logBlock, Block leafBlock, int metadata) {
        IBlockState logState = logBlock.func_176203_a(metadata);
        for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
            IBlockState leafState = leafBlock.func_176203_a(metadata).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
            TapperManager.addLeafMappingDirect(logState, leafState);
        }
    }
}

