/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.element;

import cofh.core.gui.GuiCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.init.CoreProps;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermalexpansion.init.TEProps;
import net.minecraft.util.ResourceLocation;

public class ElementSlotOverlay
extends ElementBase {
    protected SlotColor slotColor;
    protected SlotType slotType;
    protected SlotRender slotRender;

    public ElementSlotOverlay(GuiCore gui, int posX, int posY) {
        super(gui, posX, posY);
        this.texture = TEProps.textureGuiCommon;
    }

    public ElementSlotOverlay setSlotInfo(SlotColor color, SlotType type, SlotRender render) {
        this.slotColor = color;
        this.slotType = type;
        this.slotRender = render;
        return this;
    }

    public ElementSlotOverlay setSlotColor(SlotColor color) {
        this.slotColor = color;
        return this;
    }

    public ElementSlotOverlay setSlotRender(SlotRender render) {
        this.slotRender = render;
        return this;
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (!this.isVisible()) {
            return;
        }
        RenderHelper.bindTexture((ResourceLocation)this.texture);
        if (CoreProps.enableGUISlotBorders) {
            this.drawSlotWithBorder(this.posX, this.posY);
        } else {
            this.drawSlotNoBorder(this.posX, this.posY);
        }
    }

    public void drawForeground(int mouseX, int mouseY) {
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        return false;
    }

    protected void drawSlotNoBorder(int x, int y) {
        this.sizeX = 0;
        this.sizeY = 0;
        int offsetX = this.slotColor.ordinal() / 3 * 128;
        int offsetY = this.slotColor.ordinal() % 3 * 32;
        switch (this.slotType) {
            case STANDARD: {
                this.sizeX = 16;
                this.sizeY = 16;
                offsetX += 8;
                offsetY += 8;
                break;
            }
            case OUTPUT: {
                this.sizeX = 24;
                this.sizeY = 24;
                offsetX += 36;
                offsetY += 4;
                break;
            }
            case OUTPUT_DOUBLE: {
                this.sizeX = 42;
                this.sizeY = 24;
                offsetX += 75;
                offsetY += 4;
                break;
            }
            case TANK: {
                this.sizeX = 16;
                this.sizeY = 60;
                offsetX = this.slotColor.ordinal() * 32 + 8;
                offsetY = 98;
                break;
            }
            case TANK_SHORT: {
                this.sizeX = 16;
                this.sizeY = 30;
                offsetX = this.slotColor.ordinal() * 32 + 8;
                offsetY = 162;
            }
        }
        switch (this.slotRender) {
            case TOP: {
                this.sizeY /= 2;
                break;
            }
            case BOTTOM: {
                this.sizeY /= 2;
                y += this.sizeY;
                offsetY += this.sizeY;
                break;
            }
        }
        this.gui.func_73729_b(x, y, offsetX, offsetY, this.sizeX, this.sizeY);
    }

    protected void drawSlotWithBorder(int x, int y) {
        int sizeX = 32;
        int sizeY = 32;
        int offsetX = this.slotColor.ordinal() / 3 * 128;
        int offsetY = this.slotColor.ordinal() % 3 * 32;
        offsetX += this.slotType.ordinal() * 32;
        switch (this.slotType) {
            case STANDARD: {
                x -= 8;
                y -= 8;
                break;
            }
            case OUTPUT: {
                x -= 4;
                y -= 4;
                break;
            }
            case OUTPUT_DOUBLE: {
                sizeX = 64;
                x -= 11;
                y -= 4;
                break;
            }
            case TANK: {
                sizeY = 64;
                offsetX = this.slotColor.ordinal() * 32;
                offsetY = 96;
                x -= 8;
                y -= 2;
                break;
            }
            case TANK_SHORT: {
                sizeY = 34;
                offsetX = this.slotColor.ordinal() * 32;
                offsetY = 160;
                x -= 8;
                y -= 2;
            }
        }
        switch (this.slotRender) {
            case TOP: {
                sizeY /= 2;
                break;
            }
            case BOTTOM: {
                y += (sizeY /= 2);
                offsetY += sizeY;
                break;
            }
        }
        this.gui.func_73729_b(x, y, offsetX, offsetY, sizeX, sizeY);
    }

    public static enum SlotRender {
        TOP,
        BOTTOM,
        FULL;

    }

    public static enum SlotType {
        STANDARD,
        OUTPUT,
        OUTPUT_DOUBLE,
        TANK,
        TANK_SHORT;

    }

    public static enum SlotColor {
        BLUE,
        RED,
        YELLOW,
        ORANGE,
        GREEN,
        PURPLE;

    }
}

