/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.machine;

import cofh.core.gui.GuiCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementDualScaled;
import cofh.core.gui.element.ElementEnergyStored;
import cofh.core.gui.element.ElementFluid;
import cofh.core.gui.element.ElementFluidTank;
import cofh.thermalexpansion.block.machine.TilePrecipitator;
import cofh.thermalexpansion.gui.client.GuiPoweredBase;
import cofh.thermalexpansion.gui.container.machine.ContainerPrecipitator;
import cofh.thermalexpansion.gui.element.ElementSlotOverlay;
import java.io.IOException;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class GuiPrecipitator
extends GuiPoweredBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/machine/precipitator.png");
    private TilePrecipitator myTile;
    private ElementBase slotInput;
    private ElementBase slotOutput;
    private ElementFluid progressFluid;
    private ElementDualScaled progressOverlay;
    private ElementDualScaled speed;

    public GuiPrecipitator(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerPrecipitator(inventory, tile), tile, inventory.field_70458_d, TEXTURE);
        this.generateInfo("tab.thermalexpansion.machine.precipitator");
        this.myTile = (TilePrecipitator)tile;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.slotInput = this.addElement(new ElementSlotOverlay(this, 152, 9).setSlotInfo(ElementSlotOverlay.SlotColor.BLUE, ElementSlotOverlay.SlotType.TANK, ElementSlotOverlay.SlotRender.FULL));
        this.slotOutput = this.addElement(new ElementSlotOverlay(this, 76, 45).setSlotInfo(ElementSlotOverlay.SlotColor.ORANGE, ElementSlotOverlay.SlotType.OUTPUT, ElementSlotOverlay.SlotRender.FULL));
        this.addElement((ElementBase)new ElementEnergyStored((GuiCore)this, 8, 8, this.myTile.getEnergyStorage()));
        this.addElement((ElementBase)new ElementFluidTank((GuiCore)this, 152, 9, (IFluidTank)this.myTile.getTank()).setAlwaysShow(true));
        this.progressFluid = (ElementFluid)this.addElement(new ElementFluid((GuiCore)this, 112, 49).setFluid(this.myTile.getTankFluid()).setSize(24, 16));
        this.progressOverlay = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiCore)this, 112, 49).setMode(2).setBackground(false).setSize(24, 16).setTexture("cofh:textures/gui/elements/progress_fluid_left.png", 64, 16));
        this.speed = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiCore)this, 44, 49).setSize(16, 16).setTexture("cofh:textures/gui/elements/scale_snowflake.png", 32, 16));
    }

    protected void updateElementInformation() {
        super.updateElementInformation();
        this.slotInput.setVisible(this.myTile.hasSideType(1) || this.baseTile.hasSideType(8));
        this.slotOutput.setVisible(this.myTile.hasSideType(4) || this.baseTile.hasSideType(8));
        this.progressFluid.setPosition(136 - this.myTile.getScaledProgress(24), 49);
        this.progressFluid.setSize(this.myTile.getScaledProgress(24), 16);
        this.progressOverlay.setQuantity(this.myTile.getScaledProgress(24));
        this.speed.setQuantity(this.myTile.getScaledSpeed(16));
    }

    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.drawCurSelection();
        this.drawPrevSelection();
    }

    protected void func_73864_a(int mX, int mY, int mButton) throws IOException {
        if (48 <= this.mouseX && this.mouseX < 128 && 18 <= this.mouseY && this.mouseY < 36) {
            if (49 <= this.mouseX && this.mouseX < 67) {
                this.myTile.setMode(0);
            } else if (79 <= this.mouseX && this.mouseX < 97) {
                this.myTile.setMode(1);
            } else if (109 <= this.mouseX && this.mouseX < 127) {
                this.myTile.setMode(2);
            }
        } else {
            super.func_73864_a(mX, mY, mButton);
        }
    }

    private void drawCurSelection() {
        int offset = 32;
        if (this.myTile.getPrevSelection() == this.myTile.getCurSelection() && this.myTile.isActive) {
            offset = 64;
        }
        switch (this.myTile.getCurSelection()) {
            case 0: {
                this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 11, 192, offset, 32, 32);
                break;
            }
            case 1: {
                this.func_73729_b(this.field_147003_i + 72, this.field_147009_r + 11, 192, offset, 32, 32);
                break;
            }
            case 2: {
                this.func_73729_b(this.field_147003_i + 102, this.field_147009_r + 11, 192, offset, 32, 32);
            }
        }
    }

    private void drawPrevSelection() {
        switch (this.myTile.getPrevSelection()) {
            case 0: {
                this.func_73729_b(this.field_147003_i + 42, this.field_147009_r + 11, 224, 32, 32, 32);
                break;
            }
            case 1: {
                this.func_73729_b(this.field_147003_i + 72, this.field_147009_r + 11, 224, 32, 32, 32);
                break;
            }
            case 2: {
                this.func_73729_b(this.field_147003_i + 102, this.field_147009_r + 11, 224, 32, 32, 32);
            }
        }
    }
}

