/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.dynamo;

import cofh.api.core.ISecurable;
import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISteamInfo;
import cofh.core.gui.GuiCore;
import cofh.core.gui.container.IAugmentableContainer;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementEnergyStored;
import cofh.core.gui.element.tab.TabAugment;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabEnergy;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabRedstoneControl;
import cofh.core.gui.element.tab.TabSecurity;
import cofh.core.gui.element.tab.TabSteam;
import cofh.core.gui.element.tab.TabTutorial;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public abstract class GuiDynamoBase
extends GuiCore {
    protected TileDynamoBase baseTile;
    protected UUID playerName;
    protected String myTutorial = "";
    protected TabBase energyTab;
    protected TabBase steamTab;
    protected TabBase augmentTab;
    protected TabBase redstoneTab;
    protected TabBase securityTab;

    public GuiDynamoBase(Container container, TileEntity tile, EntityPlayer player, ResourceLocation texture) {
        super(container, texture);
        this.baseTile = (TileDynamoBase)tile;
        this.name = this.baseTile.func_70005_c_();
        this.playerName = SecurityHelper.getID((EntityPlayer)player);
        this.myTutorial = StringHelper.tutorialTabAugment() + "\n\n";
        if (this.baseTile.enableSecurity() && this.baseTile.isSecured()) {
            this.myTutorial = this.myTutorial + StringHelper.tutorialTabSecurity() + "\n\n";
        }
        if (this.baseTile.hasRedstoneControl()) {
            this.myTutorial = this.myTutorial + StringHelper.tutorialTabRedstone();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElement((ElementBase)new ElementEnergyStored((GuiCore)this, 80, 18, this.baseTile.getEnergyStorage()));
        this.steamTab = this.addTab((TabBase)new TabSteam((GuiCore)this, (ISteamInfo)this.baseTile, this.baseTile.isSteamProducer()));
        this.steamTab.setVisible(this.baseTile.showSteamTab());
        this.augmentTab = this.addTab((TabBase)new TabAugment((GuiCore)this, (IAugmentableContainer)this.field_147002_h));
        this.redstoneTab = this.addTab((TabBase)new TabRedstoneControl((GuiCore)this, (IRedstoneControl)this.baseTile));
        this.redstoneTab.setVisible(this.baseTile.hasRedstoneControl());
        this.securityTab = this.addTab((TabBase)new TabSecurity((GuiCore)this, (ISecurable)this.baseTile, this.playerName));
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
        this.energyTab = this.addTab((TabBase)new TabEnergy((GuiCore)this, (IEnergyInfo)this.baseTile, true));
        this.energyTab.setVisible(this.baseTile.showEnergyTab());
        this.addTab((TabBase)new TabInfo((GuiCore)this, this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermalexpansion.dynamo.0")));
        if (!this.myTutorial.isEmpty()) {
            this.addTab((TabBase)new TabTutorial((GuiCore)this, this.myTutorial));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.baseTile.canAccess()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.redstoneTab.setVisible(this.baseTile.hasRedstoneControl());
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
        this.energyTab.setVisible(this.baseTile.showEnergyTab());
        this.steamTab.setVisible(this.baseTile.showSteamTab());
    }
}

