/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import cofh.core.init.CoreEnchantments;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.storage.ItemBlockCell;
import cofh.thermalexpansion.block.storage.TileCell;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.item.ItemFrame;
import cofh.thermalexpansion.render.RenderCell;
import cofh.thermalexpansion.util.helpers.ReconfigurableHelper;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockCell
extends BlockTEBase
implements IBakeryProvider,
IModelRegister {
    public static boolean enable;
    public static ItemStack[] cell;
    public static ItemBlockCell itemBlock;

    public BlockCell() {
        super(Material.field_151573_f);
        this.func_149663_c("cell");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IUnlistedProperty[]{TEProps.CREATIVE});
        builder.add(new IUnlistedProperty[]{TEProps.LEVEL});
        builder.add(new IUnlistedProperty[]{TEProps.HOLDING});
        builder.add(new IUnlistedProperty[]{TEProps.FACING});
        builder.add(new IUnlistedProperty[]{TEProps.SIDE_CONFIG});
        builder.add(new IUnlistedProperty[]{TEProps.SCALE});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable) {
            if (TEProps.creativeTabShowAllLevels) {
                for (int j = 0; j < 5; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, 0), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, 0), TEProps.creativeTabLevel));
            }
            if (TEProps.creativeTabShowCreative) {
                items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this, 1, 0), 4));
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileCell();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileCell tile = (TileCell)world.func_175625_s(pos);
            tile.isCreative = stack.func_77978_p().func_74767_n("Creative");
            tile.enchantHolding = (byte)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            tile.amountRecv = stack.func_77978_p().func_74762_e("Recv");
            tile.amountSend = stack.func_77978_p().func_74762_e("Send");
            tile.setEnergyStored(stack.func_77978_p().func_74762_e("Energy"));
            int facing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)living);
            byte storedFacing = ReconfigurableHelper.getFacing(stack);
            byte[] sideCache = ReconfigurableHelper.getSideCache(stack, tile.getDefaultSides());
            tile.sideCache[0] = sideCache[0];
            tile.sideCache[1] = sideCache[1];
            tile.sideCache[facing] = sideCache[storedFacing];
            tile.sideCache[BlockHelper.getLeftSide((int)facing)] = sideCache[BlockHelper.getLeftSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getRightSide((int)facing)] = sideCache[BlockHelper.getRightSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getOppositeSide((int)facing)] = sideCache[BlockHelper.getOppositeSide((int)storedFacing)];
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        NBTTagCompound retTag = super.getItemStackTag(world, pos);
        TileCell tile = (TileCell)world.func_175625_s(pos);
        if (tile != null) {
            if (tile.enchantHolding > 0) {
                CoreEnchantments.addEnchantment((NBTTagCompound)retTag, (Enchantment)CoreEnchantments.holding, (int)tile.enchantHolding);
            }
            retTag.func_74768_a("Recv", tile.amountRecv);
            retTag.func_74768_a("Send", tile.amountSend);
        }
        return retTag;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return RenderCell.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper("thermalexpansion", "cell", "cell");
        ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)mapper.location);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
        ModelLoader.setCustomMeshDefinition((Item)itemBlock, (ItemMeshDefinition)mapper);
        ModelRegistryHelper.register((ModelResourceLocation)mapper.location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            StringBuilder builder = new StringBuilder(ModelBakery.defaultBlockKeyGenerator.generateKey(state));
            builder.append(",creative=").append(state.getValue((IUnlistedProperty)TEProps.CREATIVE));
            builder.append(",level=").append(state.getValue((IUnlistedProperty)TEProps.LEVEL));
            builder.append(",holding=").append(state.getValue((IUnlistedProperty)TEProps.HOLDING));
            builder.append(",facing=").append(state.getValue((IUnlistedProperty)TEProps.FACING));
            builder.append(",scale=").append(state.getValue((IUnlistedProperty)TEProps.SCALE));
            builder.append(",side_config{");
            for (byte i : (byte[])state.getValue((IUnlistedProperty)TEProps.SIDE_CONFIG)) {
                builder.append(",").append(i);
            }
            builder.append("}");
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack));
    }

    public boolean initialize() {
        this.setRegistryName("cell");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockCell((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileCell.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        cell = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            BlockCell.cell[i] = itemBlock.setDefaultTag(new ItemStack((Block)this), i);
        }
        this.addRecipes();
        return true;
    }

    private void addRecipes() {
        if (enable) {
            RecipeHelper.addShapedRecipe((ItemStack)cell[0], (Object[])new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), ItemFrame.frameCell, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), ItemMaterial.powerCoilElectrum, Character.valueOf('X'), Blocks.field_150451_bX});
        }
    }
}

