/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.BlockBakeryProperties;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import cofh.core.init.CoreEnchantments;
import cofh.core.render.IModelRegister;
import cofh.core.util.RayTracer;
import cofh.core.util.StateMapper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.storage.ItemBlockCache;
import cofh.thermalexpansion.block.storage.TileCache;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.Utils;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockCache
extends BlockTEBase
implements IModelRegister,
IWorldBlockTextureProvider {
    public static boolean enable;
    public static ItemStack[] cache;
    public static ItemBlockCache itemBlock;

    public BlockCache() {
        super(Material.field_151573_f);
        this.func_149663_c("cache");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IUnlistedProperty[]{TEProps.CREATIVE});
        builder.add(new IUnlistedProperty[]{BlockBakeryProperties.LAYER_FACE_SPRITE_MAP});
        builder.add(new IUnlistedProperty[]{TEProps.LEVEL});
        builder.add(new IUnlistedProperty[]{TEProps.HOLDING});
        builder.add(new IUnlistedProperty[]{TEProps.FACING});
        builder.add(new IUnlistedProperty[]{TEProps.SCALE});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable) {
            if (TEProps.creativeTabShowAllLevels) {
                for (int j = 0; j < 5; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, 0), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, 0), TEProps.creativeTabLevel));
            }
            if (TEProps.creativeTabShowCreative) {
                items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this, 1, 0), 4));
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileCache();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        int extractAmount;
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        boolean playSound = false;
        TileCache tile = (TileCache)world.func_175625_s(pos);
        ItemStack extract = tile.extractItem(null, extractAmount = !player.func_70093_af() && !player.field_71075_bZ.field_75098_d ? 1 : 64, true);
        if (extract.func_190926_b()) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (!player.field_71071_by.func_70441_a(extract)) {
                if (extract.func_190916_E() == extractAmount) {
                    return;
                }
                extractAmount -= extract.func_190916_E();
            }
            tile.extractItem(null, extractAmount, false);
        } else {
            player.field_71071_by.func_70441_a(extract);
            tile.extractItem(null, extractAmount, false);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.4f, 0.8f);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileCache tile = (TileCache)world.func_175625_s(pos);
            tile.isCreative = stack.func_77978_p().func_74767_n("Creative");
            tile.enchantHolding = (byte)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            tile.locked = stack.func_77978_p().func_74767_n("Lock");
            if (stack.func_77978_p().func_74764_b("Item")) {
                ItemStack stored = ItemHelper.readItemStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Item"));
                tile.setStoredItemType(stored, stored.func_190916_E());
            }
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ) && Utils.isHoldingUsableWrench(player, RayTracer.retrace((EntityPlayer)player))) {
            return true;
        }
        TileCache tile = (TileCache)world.func_175625_s(pos);
        boolean playSound = false;
        if (ItemHelper.isPlayerHoldingNothing((EntityPlayer)player)) {
            if (player.func_70093_af()) {
                tile.toggleLock();
                if (tile.locked) {
                    world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.2f, 0.8f);
                } else {
                    world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.5f);
                }
                return true;
            }
            if (!tile.getStoredItemType().func_190926_b()) {
                BlockCache.insertAllItemsFromPlayer(tile, player);
            }
            return true;
        }
        ItemStack heldStack = ItemHelper.getMainhandStack((EntityPlayer)player);
        ItemStack ret = tile.insertItem(null, heldStack, false);
        long time = player.getEntityData().func_74763_f("thermalexpansion:CacheClick");
        long currentTime = world.func_82737_E();
        player.getEntityData().func_74772_a("thermalexpansion:CacheClick", currentTime);
        if (!player.field_71075_bZ.field_75098_d) {
            if (ret != heldStack) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ret);
                playSound = true;
            }
            if (!tile.getStoredItemType().func_190926_b() && currentTime - time < 15L) {
                playSound &= !BlockCache.insertAllItemsFromPlayer(tile, player);
            }
        }
        if (playSound) {
            world.func_184133_a(null, pos, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.1f, 0.7f);
        }
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d && !player.func_70093_af()) {
            this.func_180649_a(world, pos, player);
            return false;
        }
        this.func_176208_a(world, pos, world.func_180495_p(pos), player);
        return world.func_175698_g(pos);
    }

    private static boolean insertAllItemsFromPlayer(TileCache tile, EntityPlayer player) {
        boolean playSound = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (tile.insertItem(null, player.field_71071_by.func_70301_a(i), true) == player.field_71071_by.func_70301_a(i)) continue;
            player.field_71071_by.func_70299_a(i, tile.insertItem(null, player.field_71071_by.func_70301_a(i), false));
            playSound = true;
        }
        if (playSound) {
            tile.func_145831_w().func_184133_a(null, tile.func_174877_v(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.1f, 0.7f);
        }
        return playSound;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)stack)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    @Override
    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        NBTTagCompound retTag = super.getItemStackTag(world, pos);
        TileCache tile = (TileCache)world.func_175625_s(pos);
        if (tile != null) {
            if (tile.enchantHolding > 0) {
                CoreEnchantments.addEnchantment((NBTTagCompound)retTag, (Enchantment)CoreEnchantments.holding, (int)tile.enchantHolding);
            }
            if (!tile.storedStack.func_190926_b()) {
                retTag.func_74757_a("Lock", tile.locked);
                retTag.func_74782_a("Item", (NBTBase)ItemHelper.writeItemStackToNBT((ItemStack)tile.storedStack, (int)tile.getStoredCount(), (NBTTagCompound)new NBTTagCompound()));
            }
        }
        return retTag;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, ItemStack stack) {
        boolean isCreative = itemBlock.isCreative(stack);
        byte level = itemBlock.getLevel(stack);
        if (side == EnumFacing.DOWN) {
            return isCreative ? TETextures.CACHE_BOTTOM_C : TETextures.CACHE_BOTTOM[level];
        }
        if (side == EnumFacing.UP) {
            return isCreative ? TETextures.CACHE_TOP_C : TETextures.CACHE_TOP[level];
        }
        return side != EnumFacing.NORTH ? (isCreative ? TETextures.CACHE_SIDE_C : TETextures.CACHE_SIDE[level]) : (isCreative ? TETextures.CACHE_FACE_C : TETextures.CACHE_FACE[level]);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, IBlockState state, BlockRenderLayer layer, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCache) {
            TileCache tile = (TileCache)tileEntity;
            return tile.getTexture(side.ordinal(), layer == BlockRenderLayer.SOLID ? 0 : 1);
        }
        return TextureUtils.getMissingSprite();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper("thermalexpansion", "cache", "cache");
        ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)mapper.location);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
        ModelLoader.setCustomMeshDefinition((Item)itemBlock, (ItemMeshDefinition)mapper);
        ModelRegistryHelper.register((ModelResourceLocation)mapper.location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            StringBuilder builder = new StringBuilder(ModelBakery.defaultBlockKeyGenerator.generateKey(state));
            builder.append(",creative=").append(state.getValue((IUnlistedProperty)TEProps.CREATIVE));
            builder.append(",level=").append(state.getValue((IUnlistedProperty)TEProps.LEVEL));
            builder.append(",holding=").append(state.getValue((IUnlistedProperty)TEProps.HOLDING));
            builder.append(",facing=").append(state.getValue((IUnlistedProperty)TEProps.FACING));
            builder.append(",scale=").append(state.getValue((IUnlistedProperty)TEProps.SCALE));
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack));
    }

    public boolean initialize() {
        this.setRegistryName("cache");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockCache((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileCache.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        cache = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            BlockCache.cache[i] = itemBlock.setDefaultTag(new ItemStack((Block)this), i);
        }
        this.addRecipes();
        return true;
    }

    private void addRecipes() {
        if (enable) {
            RecipeHelper.addShapedRecipe((ItemStack)cache[0], (Object[])new Object[]{" I ", "ICI", " P ", Character.valueOf('C'), "chestWood", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), ItemMaterial.redstoneServo});
        }
    }
}

