/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiRefinery;
import cofh.thermalexpansion.gui.container.machine.ContainerRefinery;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRefinery
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.REFINERY.getMetadata();
    public static int basePower = 20;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore inputTank = new FluidTankCore(4000);
    private FluidTankCore outputTank = new FluidTankCore(10000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 0);

    public static void initialize() {
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE] = new TileTEBase.SideConfig();
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE].numConfig = 7;
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}, new int[0], {0}, {0}, {0}};
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 7, 8};
        TileRefinery.SIDE_CONFIGS[TileRefinery.TYPE].defaultSides = new byte[]{1, 2, 3, 3, 3, 3};
        TileRefinery.SLOT_CONFIGS[TileRefinery.TYPE] = new TileTEBase.SlotConfig();
        TileRefinery.SLOT_CONFIGS[TileRefinery.TYPE].allowInsertionSlot = new boolean[]{false, false};
        TileRefinery.SLOT_CONFIGS[TileRefinery.TYPE].allowExtractionSlot = new boolean[]{true, false};
        TileRefinery.VALID_AUGMENTS[TileRefinery.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        GameRegistry.registerTileEntity(TileRefinery.class, (String)"thermalexpansion:machine_refinery");
        TileRefinery.config();
    }

    public static void config() {
        String category = "Machine.Refinery";
        BlockMachine.enable[TileRefinery.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileRefinery.ENERGY_CONFIGS[TileRefinery.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower);
    }

    public TileRefinery() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        this.transferOutputFluid();
        super.func_73660_a();
    }

    @Override
    public int getLightValue() {
        return this.isActive ? this.renderFluid.getFluid().getLuminosity(this.renderFluid) : 0;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        RefineryManager.RefineryRecipe recipe = RefineryManager.getRecipe(this.inputTank.getFluid());
        if (recipe == null) {
            return false;
        }
        if (this.inputTank.getFluidAmount() < recipe.getInput().amount) {
            return false;
        }
        FluidStack outputFluid = recipe.getOutputFluid();
        ItemStack outputItem = recipe.getOutputItem();
        if (!outputItem.func_190926_b() && !this.inventory[0].func_190926_b()) {
            if (!this.augmentSecondaryNull && !this.inventory[0].func_77969_a(outputItem)) {
                return false;
            }
            if (!this.augmentSecondaryNull && this.inventory[0].func_190916_E() + outputItem.func_190916_E() > outputItem.func_77976_d()) {
                return false;
            }
        }
        return this.outputTank.fill(outputFluid, false) == outputFluid.amount;
    }

    @Override
    protected boolean canFinish() {
        return this.processRem <= 0;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = RefineryManager.getRecipe(this.inputTank.getFluid()).getEnergy() * this.energyMod / 100;
        String prevID = this.renderFluid.getFluid().getName();
        this.renderFluid = this.inputTank.getFluid().copy();
        this.renderFluid.amount = 0;
        if (!prevID.equals(this.renderFluid.getFluid().getName())) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        RefineryManager.RefineryRecipe recipe = RefineryManager.getRecipe(this.inputTank.getFluid());
        if (recipe == null) {
            this.processOff();
            return;
        }
        this.outputTank.fill(recipe.getOutputFluid(), true);
        ItemStack outputItem = recipe.getOutputItem();
        if (!outputItem.func_190926_b()) {
            if (this.inventory[0].func_190926_b()) {
                this.inventory[0] = ItemHelper.cloneStack((ItemStack)outputItem);
            } else {
                this.inventory[0].func_190917_f(outputItem.func_190916_E());
            }
            if (this.inventory[0].func_190916_E() > this.inventory[0].func_77976_d()) {
                this.inventory[0].func_190920_e(this.inventory[0].func_77976_d());
            }
        }
        this.inputTank.drain(recipe.getInput().amount, true);
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (!this.inventory[0].func_190926_b()) {
            for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
                int side = i % 6;
                if (!this.isSecondaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTracker = side;
                break;
            }
        }
    }

    private void transferOutputFluid() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.outputTank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.outputTank.getFluid(), Math.min(this.outputTank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.outputTank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    @Override
    protected void setLevelFlags() {
        super.setLevelFlags();
        this.hasAutoInput = false;
        this.enableAutoInput = false;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiRefinery(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerRefinery(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.inputTank;
        }
        return this.outputTank;
    }

    public FluidStack getTankFluid(int tankIndex) {
        if (tankIndex == 0) {
            return this.inputTank.getFluid();
        }
        return this.outputTank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74762_e("TrackOut1");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut2");
        this.inputTank.readFromNBT(nbt.func_74775_l("TankIn"));
        this.outputTank.readFromNBT(nbt.func_74775_l("TankOut"));
        if (this.inputTank.getFluid() != null) {
            this.renderFluid = this.inputTank.getFluid().copy();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackOut1", this.outputTracker);
        nbt.func_74768_a("TrackOut2", this.outputTrackerFluid);
        nbt.func_74782_a("TankIn", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("TankOut", (NBTBase)this.outputTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        if (this.inputTank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.inputTank.getFluid());
        }
        payload.addFluidStack(this.outputTank.getFluid());
        return payload;
    }

    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.inputTank.setFluid(payload.getFluidStack());
        this.outputTank.setFluid(payload.getFluidStack());
    }

    protected void handleFluidPacket(PacketCoFHBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : TETextures.MACHINE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.MACHINE_ACTIVE[TYPE] : TETextures.MACHINE_FACE[TYPE]);
        }
        return TETextures.MACHINE_SIDE;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo inputInfo = TileRefinery.this.inputTank.getInfo();
                    FluidTankInfo outputInfo = TileRefinery.this.outputTank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(inputInfo.fluid, inputInfo.capacity, true, false), new FluidTankProperties(outputInfo.fluid, outputInfo.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !TileRefinery.this.allowInsertion(((TileRefinery)TileRefinery.this).sideConfig.sideTypes[TileRefinery.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    if (!RefineryManager.recipeExists(resource)) {
                        return 0;
                    }
                    return TileRefinery.this.inputTank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from != null && TileRefinery.this.isPrimaryOutput(((TileRefinery)TileRefinery.this).sideConfig.sideTypes[TileRefinery.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    if (resource == null || !resource.isFluidEqual(TileRefinery.this.outputTank.getFluid())) {
                        return null;
                    }
                    return TileRefinery.this.outputTank.drain(resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from != null && TileRefinery.this.isPrimaryOutput(((TileRefinery)TileRefinery.this).sideConfig.sideTypes[TileRefinery.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    return TileRefinery.this.outputTank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

