/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.inventory.InventoryCraftingFalse;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCrafter;
import cofh.thermalexpansion.gui.container.machine.ContainerCrafter;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCrafter
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CRAFTER.getMetadata();
    public static int basePower = 20;
    private static final int SLOT_OUTPUT = 9;
    private static final int SLOT_SCHEMATIC = 10;
    private int inputTracker;
    private int outputTracker;
    private InventoryCraftingFalse craftMatrix = new InventoryCraftingFalse(3, 3);
    private FluidTankCore tank = new FluidTankCore(10000);

    public static void initialize() {
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE] = new TileTEBase.SideConfig();
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].numConfig = 5;
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5, 6, 7, 8}, {9}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}};
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE] = new TileTEBase.SlotConfig();
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE].allowInsertionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, false, false, false};
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE].allowExtractionSlot = new boolean[]{false, false, false, false, false, false, false, false, false, true, false, false};
        TileCrafter.VALID_AUGMENTS[TileCrafter.TYPE] = new HashSet();
        GameRegistry.registerTileEntity(TileCrafter.class, (String)"thermalexpansion:machine_crafter");
        TileCrafter.config();
    }

    public static void config() {
        String category = "Machine.Crafter";
        BlockMachine.enable[TileCrafter.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileCrafter.ENERGY_CONFIGS[TileCrafter.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(20);
    }

    public TileCrafter() {
        this.inventory = new ItemStack[12];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[10].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        IRecipe recipe = ItemHelper.getCraftingRecipe((InventoryCrafting)this.craftMatrix, (World)this.field_145850_b);
        return recipe != null;
    }

    @Override
    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.inventory[9].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(9, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrafter(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrafter(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addFluidStack(this.getTankFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileCrafter.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return TileCrafter.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return TileCrafter.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return TileCrafter.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

