/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCentrifuge;
import cofh.thermalexpansion.gui.container.machine.ContainerCentrifuge;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCentrifuge
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CENTRIFUGE.getMetadata();
    public static int basePower = 20;
    private int inputTracker;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(4000);

    public static void initialize() {
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE] = new TileTEBase.SideConfig();
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE].numConfig = 7;
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2, 3, 4}, new int[0], {1, 2, 3, 4}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 4}};
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 7, 8};
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileCentrifuge.SLOT_CONFIGS[TileCentrifuge.TYPE] = new TileTEBase.SlotConfig();
        TileCentrifuge.SLOT_CONFIGS[TileCentrifuge.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false, false, false};
        TileCentrifuge.SLOT_CONFIGS[TileCentrifuge.TYPE].allowExtractionSlot = new boolean[]{false, true, true, true, true, false};
        TileCentrifuge.VALID_AUGMENTS[TileCentrifuge.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        TileCentrifuge.LIGHT_VALUES[TileCentrifuge.TYPE] = 4;
        GameRegistry.registerTileEntity(TileCentrifuge.class, (String)"thermalexpansion:machine_centrifuge");
        TileCentrifuge.config();
    }

    public static void config() {
        String category = "Machine.Centrifuge";
        BlockMachine.enable[TileCentrifuge.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileCentrifuge.ENERGY_CONFIGS[TileCentrifuge.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower);
    }

    public TileCentrifuge() {
        this.inventory = new ItemStack[6];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        this.transferOutputFluid();
        super.func_73660_a();
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        CentrifugeManager.CentrifugeRecipe recipe = CentrifugeManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < recipe.getInput().func_190916_E()) {
            return false;
        }
        FluidStack fluid = recipe.getFluid();
        List<ItemStack> outputs = recipe.getOutput();
        if (outputs.isEmpty()) {
            return fluid != null && this.tank.fill(fluid, false) == fluid.amount;
        }
        if (fluid != null && !this.augmentSecondaryNull && this.tank.fill(fluid, false) != fluid.amount) {
            return false;
        }
        boolean valid = true;
        for (int i = 0; i < outputs.size(); ++i) {
            ItemStack output = outputs.get(i);
            valid &= this.inventory[i + 1].func_190926_b() || this.inventory[i + 1].func_77969_a(output) && this.inventory[i + 1].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
        }
        return valid;
    }

    @Override
    protected boolean hasValidInput() {
        CentrifugeManager.CentrifugeRecipe recipe = CentrifugeManager.getRecipe(this.inventory[0]);
        return recipe != null && recipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = CentrifugeManager.getRecipe(this.inventory[0]).getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        CentrifugeManager.CentrifugeRecipe recipe = CentrifugeManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        List<ItemStack> outputs = recipe.getOutput();
        List<Integer> chances = recipe.getChance();
        for (int i = 0; i < outputs.size(); ++i) {
            if (this.field_145850_b.field_73012_v.nextInt(this.secondaryChance) >= chances.get(i)) continue;
            if (this.inventory[i + 1].func_190926_b()) {
                this.inventory[i + 1] = ItemHelper.cloneStack((ItemStack)outputs.get(i));
                continue;
            }
            this.inventory[i + 1].func_190917_f(outputs.get(i).func_190916_E());
        }
        FluidStack fluid = recipe.getFluid();
        this.tank.fill(fluid, true);
        this.inventory[0].func_190918_g(recipe.getInput().func_190916_E());
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        boolean foundOutput = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = 1; j < 5; ++j) {
                if (!this.transferItem(j, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                foundOutput = true;
            }
            if (!foundOutput) continue;
            this.outputTracker = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (!this.enableAutoOutput || this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isSecondaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCentrifuge(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCentrifuge(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut1");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut2");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut1", this.outputTracker);
        nbt.func_74768_a("TrackOut2", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || CentrifugeManager.recipeExists(stack);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileCentrifuge.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from != null && !TileCentrifuge.this.allowExtraction(((TileCentrifuge)TileCentrifuge.this).sideConfig.sideTypes[TileCentrifuge.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    if (resource == null || !resource.isFluidEqual(TileCentrifuge.this.tank.getFluid())) {
                        return null;
                    }
                    return TileCentrifuge.this.tank.drain(resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from != null && !TileCentrifuge.this.allowExtraction(((TileCentrifuge)TileCentrifuge.this).sideConfig.sideTypes[TileCentrifuge.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    return TileCentrifuge.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

