/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.fluid.FluidTankCore;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoReactant;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoReactant;
import cofh.thermalexpansion.util.managers.dynamo.ReactantManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDynamoReactant
extends TileDynamoBase {
    private static final int TYPE = BlockDynamo.Type.REACTANT.getMetadata();
    public static int basePower = 40;
    public static int fluidAmount = 100;
    private FluidTankCore tank = new FluidTankCore(4000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    private int currentFuelRF = 0;
    public boolean augmentElemental;

    public static void initialize() {
        TileDynamoReactant.VALID_AUGMENTS[TileDynamoReactant.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("dynamoReactantElemental");
        GameRegistry.registerTileEntity(TileDynamoReactant.class, (String)"thermalexpansion:dynamo_reactant");
        TileDynamoReactant.config();
    }

    public static void config() {
        String category = "Dynamo.Reactant";
        BlockDynamo.enable[TileDynamoReactant.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for a Reactant Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, basePower / 4, basePower * 4, comment);
        TileDynamoReactant.DEFAULT_ENERGY_CONFIG[TileDynamoReactant.TYPE] = new TileTEBase.EnergyConfig();
        DEFAULT_ENERGY_CONFIG[TYPE].setDefaultParams(basePower);
    }

    public TileDynamoReactant() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.fuelRF > 0) {
            return true;
        }
        if (this.inventory[0] == null || this.tank.getFluidAmount() < fluidAmount) {
            return false;
        }
        if (!(!this.augmentElemental || ReactantManager.validReactantElemental(this.inventory[0]) && ReactantManager.validFluidElemental(this.tank.getFluid()))) {
            return false;
        }
        return ReactantManager.reactionExists(this.inventory[0], this.tank.getFluid());
    }

    @Override
    protected void processStart() {
        ReactantManager.Reaction reaction = ReactantManager.getReaction(this.inventory[0], this.tank.getFluid());
        this.currentFuelRF = reaction.getEnergy() * this.energyMod / 100;
        this.fuelRF += this.currentFuelRF;
        this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        this.tank.drain(fluidAmount, true);
    }

    @Override
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)this.renderFluid.getFluid().getStill());
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoReactant(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDynamoReactant(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = Math.max(this.fuelRF, ReactantManager.DEFAULT_ENERGY);
        }
        return this.fuelRF * scale / this.currentFuelRF;
    }

    @Override
    public FluidTankCore getTank(int tankIndex) {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentFuelRF = nbt.func_74762_e("FuelMax");
        this.tank.readFromNBT(nbt);
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = Math.max(this.fuelRF, ReactantManager.DEFAULT_ENERGY);
        }
        if (!ReactantManager.validFluid(this.tank.getFluid())) {
            this.tank.setFluid(null);
        }
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.currentFuelRF);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.currentFuelRF);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.currentFuelRF = payload.getInt();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        FluidStack tempRender = payload.getFluidStack();
        this.renderFluid = tempRender == null ? new FluidStack(FluidRegistry.LAVA, 1000) : tempRender;
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentElemental = false;
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentElemental && "dynamoReactantElemental".equals(id)) {
            this.augmentElemental = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 4 * this.getBasePower(this.level));
            this.energyMod += 25;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.augmentElemental ? ReactantManager.validReactantElemental(stack) : ReactantManager.validReactant(stack);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side.ordinal() != this.facing || this.augmentCoilDuct ? CoreProps.SINGLE_INVENTORY : CoreProps.EMPTY_INVENTORY;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{TileDynamoReactant.this.tank.getInfo()});
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (resource == null || from != null && from.ordinal() == TileDynamoReactant.this.facing && !TileDynamoReactant.this.augmentCoilDuct) {
                        return 0;
                    }
                    if (TileDynamoReactant.this.augmentElemental) {
                        if (ReactantManager.validFluidElemental(resource)) {
                            return TileDynamoReactant.this.tank.fill(resource, doFill);
                        }
                        return 0;
                    }
                    if (ReactantManager.validFluid(resource)) {
                        return TileDynamoReactant.this.tank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (resource == null || !TileDynamoReactant.this.augmentCoilDuct && from.ordinal() == TileDynamoReactant.this.facing) {
                        return null;
                    }
                    if (resource.equals((Object)TileDynamoReactant.this.tank.getFluid())) {
                        return TileDynamoReactant.this.tank.drain(resource.amount, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (!TileDynamoReactant.this.augmentCoilDuct && from.ordinal() == TileDynamoReactant.this.facing) {
                        return null;
                    }
                    return TileDynamoReactant.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

