/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.init.CoreProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoEnervation;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoEnervation;
import cofh.thermalexpansion.util.managers.dynamo.EnervationManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileDynamoEnervation
extends TileDynamoBase {
    private static final int TYPE = BlockDynamo.Type.ENERVATION.getMetadata();
    public static int basePower = 40;
    private int currentFuelRF = 0;

    public static void initialize() {
        TileDynamoEnervation.VALID_AUGMENTS[TileDynamoEnervation.TYPE] = new HashSet();
        GameRegistry.registerTileEntity(TileDynamoEnervation.class, (String)"thermalexpansion:dynamo_enervation");
        TileDynamoEnervation.config();
    }

    public static void config() {
        String category = "Dynamo.Enervation";
        BlockDynamo.enable[TileDynamoEnervation.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for an Enervation Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, basePower / 4, basePower * 4, comment);
        TileDynamoEnervation.DEFAULT_ENERGY_CONFIG[TileDynamoEnervation.TYPE] = new TileTEBase.EnergyConfig();
        DEFAULT_ENERGY_CONFIG[TYPE].setDefaultParams(basePower);
    }

    public TileDynamoEnervation() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        return EnervationManager.getFuelEnergy(this.inventory[0]) > this.energyConfig.maxPower;
    }

    @Override
    protected void processStart() {
        if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            IEnergyContainerItem container = (IEnergyContainerItem)this.inventory[0].func_77973_b();
            this.currentFuelRF = container.extractEnergy(this.inventory[0], container.getEnergyStored(this.inventory[0]), false);
            this.fuelRF += this.currentFuelRF;
        } else {
            this.currentFuelRF = EnervationManager.getFuelEnergy(this.inventory[0]) * this.energyMod / 100;
            this.fuelRF += this.currentFuelRF;
            this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        }
    }

    @Override
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)TFFluids.fluidRedstone.getStill());
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoEnervation(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDynamoEnervation(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = Math.max(this.fuelRF, EnervationManager.DEFAULT_ENERGY);
        } else if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            return scale;
        }
        return this.fuelRF * scale / this.currentFuelRF;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentFuelRF = nbt.func_74762_e("FuelMax");
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = Math.max(this.fuelRF, EnervationManager.DEFAULT_ENERGY);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.currentFuelRF);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.currentFuelRF);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.currentFuelRF = payload.getInt();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return EnervationManager.getFuelEnergy(stack) > 0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == null || side.ordinal() != this.facing || this.augmentCoilDuct ? CoreProps.SINGLE_INVENTORY : CoreProps.EMPTY_INVENTORY;
    }
}

