/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.api.core.IPortableData;
import cofh.core.block.TileCore;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.ITileInfoPacketHandler;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.thermalexpansion.ThermalExpansion;
import mcjty.theoneprobe.api.IProbeInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileTEBase
extends TileCore
implements ITileInfoPacketHandler,
ITilePacketHandler,
IPortableData {
    protected String tileName = "";
    public static final int NONE = 0;
    public static final int INPUT_ALL = 1;
    public static final int OUTPUT_PRIMARY = 2;
    public static final int OUTPUT_SECONDARY = 3;
    public static final int OUTPUT_ALL = 4;
    public static final int INPUT_PRIMARY = 5;
    public static final int INPUT_SECONDARY = 6;
    public static final int OPEN = 7;
    public static final int OMNI = 8;
    public static boolean[] SIDE_INSERTION = new boolean[]{false, true, false, false, false, true, true, true, true};
    public static boolean[] SIDE_EXTRACTION = new boolean[]{false, false, true, true, true, false, false, true, true};
    public static boolean[] SIDE_INPUT_PRIMARY = new boolean[]{false, true, false, false, false, true, false, false, true};
    public static boolean[] SIDE_INPUT_SECONDARY = new boolean[]{false, true, false, false, false, false, true, false, true};
    public static boolean[] SIDE_OUTPUT_PRIMARY = new boolean[]{false, false, true, false, true, false, false, false, true};
    public static boolean[] SIDE_OUTPUT_SECONDARY = new boolean[]{false, false, false, true, true, false, false, false, true};

    protected boolean setName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        this.tileName = name;
        return true;
    }

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        return true;
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        return true;
    }

    public int getInvSlotCount() {
        return 0;
    }

    public int getScaledProgress(int scale) {
        return 0;
    }

    public int getScaledSpeed(int scale) {
        return 0;
    }

    public boolean hasGui() {
        return false;
    }

    public boolean openGui(EntityPlayer player) {
        if (this.hasGui()) {
            player.openGui((Object)ThermalExpansion.instance, 0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            return true;
        }
        return false;
    }

    public void sendGuiNetworkData(Container container, IContainerListener listener) {
        PacketCoFHBase guiPacket;
        if (listener instanceof EntityPlayer && (guiPacket = this.getGuiPacket()) != null) {
            PacketHandler.sendTo((PacketBase)guiPacket, (EntityPlayer)((EntityPlayer)listener));
        }
    }

    public FluidTankCore getTank() {
        return null;
    }

    public FluidStack getTankFluid() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("Name")) {
            this.tileName = nbt.func_74779_i("Name");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("Version", "5.3.3");
        if (!this.tileName.isEmpty()) {
            nbt.func_74778_a("Name", this.tileName);
        }
        return nbt;
    }

    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addString(this.tileName);
        return payload;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        this.tileName = payload.getString();
        this.field_145850_b.func_175664_x(this.field_174879_c);
    }

    public void handleTileInfoPacket(PacketCoFHBase payload, boolean isServer, EntityPlayer thePlayer) {
        switch (TileCore.TilePacketID.values()[payload.getByte()]) {
            case S_GUI: {
                this.handleGuiPacket(payload);
                return;
            }
            case S_FLUID: {
                this.handleFluidPacket(payload);
                return;
            }
            case C_ACCESS: {
                this.handleAccessPacket(payload);
                return;
            }
            case C_CONFIG: {
                this.handleConfigPacket(payload);
                return;
            }
            case C_MODE: {
                this.handleModePacket(payload);
                return;
            }
        }
    }

    public String getDataType() {
        return this.getTileName();
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        if (!this.canPlayerAccess(player)) {
            return;
        }
        if (this.readPortableTagInternal(player, tag)) {
            this.markChunkDirty();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        if (!this.canPlayerAccess(player)) {
            return;
        }
        this.writePortableTagInternal(player, tag);
    }

    public void provideInfo(IProbeInfo info, EnumFacing facing, EntityPlayer player) {
        info.text("Progress: ");
        info.progress(this.getScaledProgress(100), 100);
    }

    public boolean allowInsertion(int type) {
        return SIDE_INSERTION[type];
    }

    public boolean allowExtraction(int type) {
        return SIDE_EXTRACTION[type];
    }

    public boolean isPrimaryInput(int type) {
        return SIDE_INPUT_PRIMARY[type];
    }

    public boolean isSecondaryInput(int type) {
        return SIDE_INPUT_SECONDARY[type];
    }

    public boolean isPrimaryOutput(int type) {
        return SIDE_OUTPUT_PRIMARY[type];
    }

    public boolean isSecondaryOutput(int type) {
        return SIDE_OUTPUT_SECONDARY[type];
    }

    public static class SlotConfig {
        public boolean[] allowInsertionSlot;
        public boolean[] allowExtractionSlot;
    }

    public static class SideConfig {
        public int numConfig;
        public int[] sideTypes;
        public int[][] slotGroups;
        public byte[] defaultSides;
    }

    public static class EnergyConfig {
        public int minPower = 8;
        public int maxPower = 80;
        public int maxEnergy = 20000;
        public int minPowerLevel = this.maxEnergy / 10;
        public int maxPowerLevel = 9 * this.maxEnergy / 10;
        public int energyRamp = this.maxPowerLevel / this.maxPower;

        public EnergyConfig() {
        }

        public EnergyConfig(EnergyConfig config) {
            this.minPower = config.minPower;
            this.maxPower = config.maxPower;
            this.maxEnergy = config.maxEnergy;
            this.minPowerLevel = config.minPowerLevel;
            this.maxPowerLevel = config.maxPowerLevel;
            this.energyRamp = config.energyRamp;
        }

        public EnergyConfig copy() {
            return new EnergyConfig(this);
        }

        public boolean setDefaultParams(int basePower) {
            this.maxPower = basePower;
            this.minPower = basePower / 10;
            this.maxEnergy = basePower * 1000;
            this.maxPowerLevel = 9 * this.maxEnergy / 10;
            this.minPowerLevel = this.maxPowerLevel / 10;
            this.energyRamp = this.maxPowerLevel / basePower;
            return true;
        }
    }
}

