/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import codechicken.lib.vec.Vector3;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.audio.ISoundSource;
import cofh.core.audio.SoundTile;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.RedstoneControlHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.SoundHelper;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.network.PacketTEBase;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileRSControl
extends TileTEBase
implements IRedstoneControl,
ISoundSource {
    public boolean isActive;
    protected boolean playSound;
    protected int powerLevel;
    protected boolean isPowered;
    protected boolean wasPowered;
    protected IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.DISABLED;

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        this.rsMode = RedstoneControlHelper.getControlFromNBT((NBTTagCompound)tag);
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)tag, (IRedstoneControl)this);
        return true;
    }

    public void blockPlaced() {
        this.onNeighborBlockChange();
    }

    public void onNeighborBlockChange() {
        this.wasPowered = this.isPowered;
        this.powerLevel = this.field_145850_b.func_175687_A(this.field_174879_c);
        boolean bl = this.isPowered = this.powerLevel > 0;
        if (this.wasPowered != this.isPowered && this.sendRedstoneUpdates()) {
            PacketTEBase.sendRSPowerUpdatePacketToClients(this, this.field_145850_b, this.field_174879_c);
            this.onRedstoneUpdate();
        }
    }

    public void onRedstoneUpdate() {
    }

    protected boolean sendRedstoneUpdates() {
        return false;
    }

    public final boolean redstoneControlOrDisable() {
        return this.rsMode.isDisabled() || this.isPowered == this.rsMode.getState();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isActive = nbt.func_74767_n("Active");
        NBTTagCompound rsTag = nbt.func_74775_l("RS");
        this.isPowered = rsTag.func_74767_n("Power");
        this.powerLevel = rsTag.func_74771_c("Level");
        this.rsMode = IRedstoneControl.ControlMode.values()[rsTag.func_74771_c("Mode")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Active", this.isActive);
        NBTTagCompound rsTag = new NBTTagCompound();
        rsTag.func_74757_a("Power", this.isPowered);
        rsTag.func_74774_a("Level", (byte)this.powerLevel);
        rsTag.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        nbt.func_74782_a("RS", (NBTBase)rsTag);
        return nbt;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addBool(this.isPowered);
        payload.addByte(this.rsMode.ordinal());
        payload.addBool(this.isActive);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.isPowered = payload.getBool();
        this.rsMode = IRedstoneControl.ControlMode.values()[payload.getByte()];
        this.playSound = this.isActive = payload.getBool();
        if (this.playSound && this.getSoundEvent() != null && TEProps.enableSounds) {
            SoundHelper.playSound((ISound)this.getSound());
        }
    }

    public final void setPowered(boolean isPowered) {
        this.wasPowered = this.isPowered;
        this.isPowered = isPowered;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            this.callBlockUpdate();
        }
    }

    public final boolean isPowered() {
        return this.isPowered;
    }

    public final boolean setControl(IRedstoneControl.ControlMode control) {
        this.rsMode = control;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            PacketTEBase.sendRSConfigUpdatePacketToServer(this, this.field_174879_c);
        }
        return true;
    }

    public final IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new SoundTile((ISoundSource)this, this.getSoundEvent(), this.getVolume(), 1.0f, true, 0, Vector3.fromTileCenter((TileEntity)this).vec3());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldPlaySound() {
        return !this.field_145846_f && this.playSound;
    }

    protected float getVolume() {
        return 1.0f;
    }

    protected SoundEvent getSoundEvent() {
        return null;
    }
}

