/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion;

import cofh.core.init.CoreProps;
import cofh.core.util.ConfigHandler;
import cofh.thermalexpansion.gui.GuiHandler;
import cofh.thermalexpansion.init.TEBlocks;
import cofh.thermalexpansion.init.TEItems;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.item.ItemFlorb;
import cofh.thermalexpansion.network.PacketTEBase;
import cofh.thermalexpansion.plugins.ActuallyAdditionsPlugin;
import cofh.thermalexpansion.plugins.BiomesOPlentyPlugin;
import cofh.thermalexpansion.plugins.ForestryPlugin;
import cofh.thermalexpansion.plugins.HarvestcraftPlugin;
import cofh.thermalexpansion.plugins.NaturaPlugin;
import cofh.thermalexpansion.plugins.QuarkPlugin;
import cofh.thermalexpansion.plugins.RusticPlugin;
import cofh.thermalexpansion.plugins.TConstructPlugin;
import cofh.thermalexpansion.proxy.Proxy;
import cofh.thermalexpansion.util.IMCHandler;
import cofh.thermalexpansion.util.managers.CoolantManager;
import cofh.thermalexpansion.util.managers.FisherManager;
import cofh.thermalexpansion.util.managers.TapperManager;
import cofh.thermalexpansion.util.managers.dynamo.CompressionManager;
import cofh.thermalexpansion.util.managers.dynamo.EnervationManager;
import cofh.thermalexpansion.util.managers.dynamo.MagmaticManager;
import cofh.thermalexpansion.util.managers.dynamo.NumismaticManager;
import cofh.thermalexpansion.util.managers.dynamo.ReactantManager;
import cofh.thermalexpansion.util.managers.dynamo.SteamManager;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.io.File;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="thermalexpansion", name="Thermal Expansion", version="5.3.3", dependencies="required-after:cofhcore@[4.3.3,4.4.0);required-after:thermalfoundation@[2.3.3,2.4.0);required-after:codechickenlib@[3.1.1,);", updateJSON="https://raw.github.com/cofh/version/master/thermalexpansion_update.json", acceptedMinecraftVersions="[1.12]")
public class ThermalExpansion {
    public static final String MOD_ID = "thermalexpansion";
    public static final String MOD_NAME = "Thermal Expansion";
    public static final String VERSION = "5.3.3";
    public static final String VERSION_MAX = "5.4.0";
    public static final String VERSION_GROUP = "required-after:thermalexpansion@[5.3.3,5.4.0);";
    public static final String UPDATE_URL = "https://raw.github.com/cofh/version/master/thermalexpansion_update.json";
    public static final String DEPENDENCIES = "required-after:cofhcore@[4.3.3,4.4.0);required-after:thermalfoundation@[2.3.3,2.4.0);required-after:codechickenlib@[3.1.1,);";
    public static final String MOD_GUI_FACTORY = "cofh.thermalexpansion.gui.GuiConfigTEFactory";
    @Mod.Instance(value="thermalexpansion")
    public static ThermalExpansion instance;
    @SidedProxy(clientSide="cofh.thermalexpansion.proxy.ProxyClient", serverSide="cofh.thermalexpansion.proxy.Proxy")
    public static Proxy proxy;
    public static final Logger LOG;
    public static final ConfigHandler CONFIG;
    public static final ConfigHandler CONFIG_CLIENT;
    public static final GuiHandler GUI_HANDLER;
    public static CreativeTabs tabCommon;
    public static CreativeTabs tabItems;
    public static CreativeTabs tabFlorbs;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CONFIG.setConfiguration(new Configuration(new File(CoreProps.configDir, "/cofh/thermalexpansion/common.cfg"), true));
        CONFIG_CLIENT.setConfiguration(new Configuration(new File(CoreProps.configDir, "/cofh/thermalexpansion/client.cfg"), true));
        TEProps.preInit();
        TEBlocks.preInit();
        TEItems.preInit();
        TESounds.preInit();
        this.registerHandlers();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        proxy.initialize(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.managerInitialize();
        this.pluginInitialize();
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        IMCHandler.INSTANCE.handleIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)this));
        CONFIG.cleanUp(false, true);
        CONFIG_CLIENT.cleanUp(false, true);
        LOG.info("Thermal Expansion: Load Complete.");
    }

    @Mod.EventHandler
    public void handleIdMappingEvent(FMLModIdMappingEvent event) {
        this.managerRefresh();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        IMCHandler.INSTANCE.handleIMC((List<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    private void registerHandlers() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)GUI_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        PacketTEBase.initialize();
    }

    private void managerInitialize() {
        FurnaceManager.initialize();
        PulverizerManager.initialize();
        SawmillManager.initialize();
        SmelterManager.initialize();
        InsolatorManager.initialize();
        CompactorManager.initialize();
        CrucibleManager.initialize();
        RefineryManager.initialize();
        TransposerManager.initialize();
        ChargerManager.initialize();
        CentrifugeManager.initialize();
        EnchanterManager.initialize();
        CoolantManager.initialize();
        TapperManager.initialize();
        FisherManager.initialize();
        SteamManager.initialize();
        MagmaticManager.initialize();
        CompressionManager.initialize();
        ReactantManager.initialize();
        EnervationManager.initialize();
        NumismaticManager.initialize();
        ItemFlorb.parseFlorbs();
    }

    private synchronized void managerRefresh() {
        FurnaceManager.refresh();
        PulverizerManager.refresh();
        SawmillManager.refresh();
        SmelterManager.refresh();
        InsolatorManager.refresh();
        CompactorManager.refresh();
        CrucibleManager.refresh();
        RefineryManager.refresh();
        TransposerManager.refresh();
        ChargerManager.refresh();
        CentrifugeManager.refresh();
        EnchanterManager.refresh();
        TapperManager.refresh();
        FisherManager.refresh();
        SteamManager.refresh();
        MagmaticManager.refresh();
        CompressionManager.refresh();
        ReactantManager.refresh();
        EnervationManager.refresh();
        NumismaticManager.refresh();
    }

    private void pluginInitialize() {
        ActuallyAdditionsPlugin.initialize();
        BiomesOPlentyPlugin.initialize();
        ForestryPlugin.initialize();
        HarvestcraftPlugin.initialize();
        NaturaPlugin.initialize();
        QuarkPlugin.initialize();
        RusticPlugin.initialize();
        TConstructPlugin.initialize();
    }

    static {
        LOG = LogManager.getLogger((String)MOD_ID);
        CONFIG = new ConfigHandler(VERSION);
        CONFIG_CLIENT = new ConfigHandler(VERSION);
        GUI_HANDLER = new GuiHandler();
    }
}

