/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hunternif.mc.atlas.util.Config;
import hunternif.mc.atlas.util.FileUtil;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.SaveData;
import java.io.File;

public abstract class AbstractJSONConfig<T extends SaveData>
implements Config<T> {
    private final File file;

    protected AbstractJSONConfig(File file) {
        this.file = file;
    }

    @Override
    public void load(T data) {
        JsonElement root = FileUtil.readJson(this.file);
        if (root == null) {
            Log.info("Config %s not found; creating new", this.file.getName());
            this.save(data);
            return;
        }
        try {
            JsonObject jsonData;
            int version;
            JsonElement versionElem = root.getAsJsonObject().get("version");
            boolean outdated = false;
            if (versionElem == null) {
                Log.warn("Outdated config %s", this.file.getName());
                version = 0;
                jsonData = root.getAsJsonObject();
                outdated = true;
            } else {
                JsonElement jsonElem;
                version = versionElem.getAsInt();
                if (this.currentVersion() > version) {
                    Log.warn("Outdated config %s: version was %d, but current is %d", this.file.getName(), version, this.currentVersion());
                    outdated = true;
                }
                if ((jsonElem = root.getAsJsonObject().get("data")) == null) {
                    Log.error("Malformed config " + this.file.getName(), new Object[0]);
                    return;
                }
                jsonData = jsonElem.getAsJsonObject();
            }
            this.loadData(jsonData, data, version);
            if (outdated) {
                this.save(data);
            }
        }
        catch (IllegalStateException | NumberFormatException e) {
            Log.error(e, "Malformed config %s", this.file.getName());
        }
    }

    @Override
    public void save(T data) {
        JsonObject root = new JsonObject();
        root.addProperty("version", (Number)this.currentVersion());
        JsonObject jsonData = new JsonObject();
        this.saveData(jsonData, data);
        root.add("data", (JsonElement)jsonData);
        FileUtil.writeJson((JsonElement)root, this.file);
    }

    protected abstract void loadData(JsonObject var1, T var2, int var3);

    protected abstract void saveData(JsonObject var1, T var2);

    protected abstract int currentVersion();
}

