/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.registry.MarkerTypes;
import hunternif.mc.atlas.util.DummyWorldAccess;
import hunternif.mc.atlas.util.Log;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NetherPortalWatcher
extends DummyWorldAccess {
    private static final String[] inPortalFieldNames = new String[]{"inPortal", "field_71087_bX", "bX"};
    private final Set<Integer> teleportingPlayerIDs = Collections.newSetFromMap(new ConcurrentHashMap());

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            event.getWorld().func_72954_a((IWorldEventListener)this);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            event.getWorld().func_72848_b((IWorldEventListener)this);
        }
    }

    @Override
    public void func_72703_a(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (this.teleportingPlayerIDs.remove(entity.func_145782_y())) {
                Log.info("Entering", new Object[0]);
                int dimension = player.field_71093_bK;
                Log.info("Player %s teleported to the %s", player.func_146103_bH().getName(), dimension == 0 ? "Overworld" : "Nether");
                this.addPortalMarkerIfNone(player, dimension);
            }
        }
    }

    @Override
    public void func_72709_b(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (NetherPortalWatcher.isEntityInPortal(entity)) {
                Log.info("Exiting", new Object[0]);
                int dimension = player.func_130014_f_().field_73011_w.getDimension();
                Log.info("Player %s left the %s", player.func_146103_bH().getName(), dimension == 0 ? "Overworld" : "Nether");
                this.teleportingPlayerIDs.add(entity.func_145782_y());
                this.addPortalMarkerIfNone(player, dimension);
            }
        }
    }

    private void addPortalMarkerIfNone(EntityPlayer player, int dimension) {
        WorldServer world = AntiqueAtlasMod.proxy.getServer().func_71218_a(dimension);
        if (!SettingsConfig.gameplay.itemNeeded) {
            this.addPortalMarkerIfNone(player, (World)world, dimension, player.func_110124_au().hashCode());
            return;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != RegistrarAntiqueAtlas.ATLAS) continue;
            this.addPortalMarkerIfNone(player, (World)world, dimension, stack.func_77952_i());
        }
    }

    private void addPortalMarkerIfNone(EntityPlayer player, World world, int dimension, int atlasID) {
        int z;
        int x;
        DimensionMarkersData data = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world).getMarkersDataInDimension(dimension);
        List<Marker> markers = data.getMarkersAtChunk(((x = (int)player.field_70165_t) >> 4) / 8, ((z = (int)player.field_70161_v) >> 4) / 8);
        if (markers != null) {
            for (Marker marker : markers) {
                if (!marker.getType().equals(MarkerTypes.NETHER_PORTAL)) continue;
                return;
            }
        }
        AtlasAPI.markers.putMarker(world, false, atlasID, MarkerTypes.NETHER_PORTAL.getRegistryName().toString(), "gui.antiqueatlas.marker.netherPortal", x, z);
    }

    private static boolean isEntityInPortal(Entity entity) {
        return (Boolean)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String[])inPortalFieldNames);
    }
}

