/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.atlas.marker.MarkersData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class MarkersDataHandler {
    private static final String MARKERS_DATA_PREFIX = "aaMarkers_";
    private final Map<String, MarkersData> markersDataClientCache = new ConcurrentHashMap<String, MarkersData>();

    public MarkersData getMarkersData(ItemStack stack, World world) {
        if (stack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
            return this.getMarkersData(stack.func_77952_i(), world);
        }
        return null;
    }

    public MarkersData getMarkersData(int atlasID, World world) {
        String key = this.getMarkersDataKey(atlasID);
        MarkersData data = null;
        if (world.field_72995_K) {
            data = this.markersDataClientCache.get(key);
        }
        if (data == null) {
            data = (MarkersData)world.func_72943_a(MarkersData.class, key);
            if (data == null) {
                data = new MarkersData(key);
                world.func_72823_a(key, (WorldSavedData)data);
            }
            if (world.field_72995_K) {
                this.markersDataClientCache.put(key, data);
            }
        }
        return data;
    }

    private String getMarkersDataKey(int atlasID) {
        return MARKERS_DATA_PREFIX + atlasID;
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.markersDataClientCache.clear();
    }
}

