/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.item;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.item.RecipeBase;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class RecipeAtlasCombining
extends RecipeBase {
    public RecipeAtlasCombining() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return this.matches((IInventory)inv);
    }

    private boolean matches(IInventory inv) {
        int atlasesFound = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != RegistrarAntiqueAtlas.ATLAS) continue;
            ++atlasesFound;
        }
        return atlasesFound > 1;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack firstAtlas = ItemStack.field_190927_a;
        ArrayList<Integer> atlasIds = new ArrayList<Integer>(9);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != RegistrarAntiqueAtlas.ATLAS) continue;
            if (firstAtlas.func_190926_b()) {
                firstAtlas = stack;
                continue;
            }
            atlasIds.add(stack.func_77952_i());
        }
        return atlasIds.size() < 1 ? ItemStack.field_190927_a : firstAtlas.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting.func_77973_b() != RegistrarAntiqueAtlas.ATLAS || !this.matches(event.craftMatrix)) {
            return;
        }
        World world = event.player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        int atlasID = world.func_72841_b("aAtlas");
        AtlasData destBiomes = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, world);
        destBiomes.func_76185_a();
        MarkersData destMarkers = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
        destMarkers.func_76185_a();
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = event.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            AtlasData srcBiomes = AntiqueAtlasMod.atlasData.getAtlasData(stack, world);
            if (destBiomes != null && srcBiomes != null && destBiomes != srcBiomes) {
                for (int dim : srcBiomes.getVisitedDimensions()) {
                    destBiomes.getSeenChunksInDimension(dim).putAll(srcBiomes.getSeenChunksInDimension(dim));
                }
            }
            MarkersData srcMarkers = AntiqueAtlasMod.markersData.getMarkersData(stack, world);
            if (destMarkers == null || srcMarkers == null || destMarkers == srcMarkers) continue;
            for (int dim : srcMarkers.getVisitedDimensions()) {
                for (Marker marker : srcMarkers.getMarkersDataInDimension(dim).getAllMarkers()) {
                    destMarkers.createAndSaveMarker(marker.getType(), marker.getLabel(), dim, marker.getX(), marker.getZ(), marker.isVisibleAhead());
                }
            }
        }
        event.crafting.func_77964_b(atlasID);
    }
}

