/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.Log;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StructureWatcher {
    private final String datFileName;
    private MarkerType marker;
    private MarkerType tileMarker;
    private String markerLabel;
    private String tileMarkerLabel;
    private final int dim;
    private final Set<String> visited = new HashSet<String>();

    public StructureWatcher(String datFileName, int dim, MarkerType marker, String label) {
        this.marker = marker;
        this.markerLabel = label;
        this.dim = dim;
        this.datFileName = datFileName;
    }

    public StructureWatcher setTileMarker(MarkerType type, String label) {
        this.tileMarker = type;
        this.tileMarkerLabel = label;
        return this;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == this.dim) {
            this.visitAllUnvisitedStructures(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Post event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == this.dim) {
            this.visitAllUnvisitedStructures(event.getWorld());
        }
    }

    private void visitAllUnvisitedStructures(World world) {
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, this.datFileName);
        if (data == null) {
            return;
        }
        NBTTagCompound nbtData = data.func_143041_a();
        Set tagSet = nbtData.func_150296_c();
        for (String coords : tagSet) {
            NBTBase tag;
            if (this.visited.contains(coords) || (tag = nbtData.func_74781_a(coords)).func_74732_a() != 10) continue;
            this.visitStructure(world, (NBTTagCompound)tag);
            this.visited.add(coords);
        }
    }

    private void visitStructure(World world, NBTTagCompound tag) {
        int chunkX = tag.func_74762_e("ChunkX");
        int chunkZ = tag.func_74762_e("ChunkZ");
        Log.info("\tVisiting " + this.datFileName + " in dimension #%d \"%s\" at chunk (%d, %d) ~ blocks (%d, %d)", world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p().func_186065_b(), chunkX, chunkZ, chunkX << 4, chunkZ << 4);
        boolean foundMarker = false;
        boolean foundTileMarker = false;
        List<Marker> markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_73011_w.getDimension(), chunkX / 8, chunkZ / 8);
        if (markers != null) {
            for (Marker marker : markers) {
                if (!foundMarker && marker.getChunkX() == chunkX && marker.getChunkZ() == chunkZ && marker.getType().equals(this.marker)) {
                    foundMarker = true;
                }
                if (foundTileMarker || this.tileMarker == null || marker.getChunkX() != chunkX || marker.getChunkZ() != chunkZ || !marker.getType().equals(this.tileMarker)) continue;
                foundTileMarker = true;
            }
        }
        if (SettingsConfig.gameplay.autoVillageMarkers) {
            if (!foundMarker) {
                AtlasAPI.markers.putGlobalMarker(world, false, this.marker.getRegistryName().toString(), this.markerLabel, (chunkX << 4) + 8, (chunkZ << 4) + 8);
            }
            if (this.tileMarker != null && !foundTileMarker) {
                AtlasAPI.markers.putGlobalMarker(world, false, this.tileMarker.getRegistryName().toString(), this.tileMarkerLabel, (chunkX << 4) + 8, (chunkZ << 4) + 8);
            }
        }
    }

    private void clearAllMarkers(World world) {
        Collection<Marker> markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersInDimension(world.field_73011_w.getDimension());
        for (Marker marker : markers) {
            if (marker.getType().equals(this.marker)) {
                AtlasAPI.markers.deleteGlobalMarker(world, marker.getId());
            }
            if (this.tileMarker == null || !marker.getType().equals(this.tileMarker)) continue;
            AtlasAPI.markers.deleteGlobalMarker(world, marker.getId());
        }
    }
}

